/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.common.utils;

public class Logger {

    private final org.apache.log4j.Logger s_logger;

    public Logger(Class clazz) {
        s_logger = org.apache.log4j.Logger.getLogger(clazz);
    }

    public void trace(Object message, Object... args) {
        if (s_logger.isTraceEnabled()) {
            if (args.length > 0) {
                message = String.format(message.toString(), args);
            }
            s_logger.trace(message);
        }
    }

    public void debug(Object message, Object... args) {
        if (s_logger.isDebugEnabled()) {
            if (args.length > 0) {
                message = String.format(message.toString(), args);
            }
            s_logger.debug(message);
        }
    }

    public void info(Object message, Object... args) {
        if (s_logger.isInfoEnabled()) {
            if (args.length > 0) {
                message = String.format(message.toString(), args);
            }
            s_logger.info(message);
        }
    }

    public void error(Object message, Object... args) {
        if (args.length > 0) {
            message = String.format(message.toString(), args);
        }
        s_logger.error(message);
    }

    public void error(Object message, Throwable t) {
        s_logger.error(message, t);
    }

    public void warn(Object message, Object... args) {
        if (args.length > 0) {
            message = String.format(message.toString(), args);
        }
        s_logger.warn(message);
    }
}
