/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.Consumer;
import net.nuage.vsp.acs.client.api.NuageVspAclClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspRestApi;
import net.nuage.vsp.acs.client.api.model.Protocol;
import net.nuage.vsp.acs.client.api.model.VspAclRule;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.VspStaticRoute;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.NuageVspConstants;
import net.nuage.vsp.acs.client.common.model.Acl;
import net.nuage.vsp.acs.client.common.model.AclRulesDetails;
import net.nuage.vsp.acs.client.common.model.NetworkDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspFilter;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.common.utils.NetUtils;
import net.nuage.vsp.acs.client.common.utils.UuidUtils;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class NuageVspAclClientImpl
implements NuageVspAclClient {
    private static final Logger s_logger = new Logger(NuageVspAclClientImpl.class);
    public static final Random RANDOM = new Random();
    private final NuageVspRestApi api;

    public NuageVspAclClientImpl(NuageVspRestApi api) {
        this.api = api;
    }

    public NuageVspObject getOnlyACLTemplateAssociatedToDomain(String networkUuid, NuageVspEntity domainType, String domainId, NuageVspEntity aclTemplateType) throws NuageVspException {
        return (NuageVspObject)Iterables.getOnlyElement(this.getACLTemplatesAssociatedToDomain(networkUuid, domainType, domainId, aclTemplateType, Acl.AclTemplatePriorityType.NONE, true));
    }

    @Override
    public NuageVspObject findACLTemplate(NuageVspEntity parentType, String parentId, NuageVspEntity aclTemplateType, Acl.AclTemplatePriorityType priorityType, Integer priority) throws NuageVspApiException {
        String aclTemplates;
        switch (priorityType) {
            case TOP: 
            case BOTTOM: {
                aclTemplates = this.api.getResources(parentType, parentId, aclTemplateType, NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, (Object)priorityType);
                break;
            }
            default: {
                aclTemplates = this.api.getResources(parentType, parentId, aclTemplateType, NuageVspAttribute.ACLTEMPLATES_PRIORITY, priority);
            }
        }
        if (StringUtils.isNotBlank((String)aclTemplates)) {
            return this.api.getOnlyJsonEntity(aclTemplateType, aclTemplates);
        }
        return null;
    }

    @Override
    public NuageVspObject findOrCreateACLTemplate(String vpcOrSubnetUuid, NuageVspEntity parentType, String parentId, NuageVspEntity aclTemplateType, Acl.AclTemplatePriorityType priorityType, Integer priority) throws NuageVspApiException {
        NuageVspObject aclTemplate = this.findACLTemplate(parentType, parentId, aclTemplateType, priorityType, priority);
        if (aclTemplate != null) {
            return aclTemplate;
        }
        aclTemplate = this.api.createNuageVspObject(aclTemplateType);
        aclTemplate.setExternalId(vpcOrSubnetUuid);
        StringBuilder name = new StringBuilder();
        switch (aclTemplateType) {
            case INGRESS_ACLTEMPLATES: {
                name.append("Ingress");
                break;
            }
            case EGRESS_ACLTEMPLATES: {
                name.append("Egress");
                break;
            }
            case EGRESS_DOMAIN_FIP_ACLTEMPLATES: {
                name.append("Egress Domain FIP");
            }
        }
        name.append(" ACL");
        switch (priorityType) {
            case TOP: {
                name.append(" Top");
                break;
            }
            case BOTTOM: {
                name.append(" Bottom");
            }
        }
        aclTemplate.set(NuageVspAttribute.NAME, name.toString());
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_ACTIVE, true);
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, (Object)priorityType);
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_PRIORITY, priority);
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_ALLOW_IP, false);
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_ALLOW_NON_IP, false);
        try {
            aclTemplate = this.api.createResource(parentType, parentId, aclTemplate);
            s_logger.debug("Created Default ACLTemplate for network %s in VSP . Response from VSP is %s.", vpcOrSubnetUuid, aclTemplate);
        }
        catch (NuageVspException e) {
            throw new NuageVspApiException("Failed to create ACL Template", e);
        }
        return aclTemplate;
    }

    @Override
    public List<NuageVspObject> getACLTemplatesAssociatedToDomain(String networkUuid, NuageVspEntity domainType, String domainId, NuageVspEntity aclTemplateType, Acl.AclTemplatePriorityType priorityType, boolean throwExceptionIfNotPresent) throws NuageVspException {
        String aclTemplates = priorityType != null ? this.api.getResources(domainType, domainId, aclTemplateType, NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, (Object)priorityType) : this.api.getResources(domainType, domainId, aclTemplateType);
        if (StringUtils.isNotBlank((String)aclTemplates)) {
            return this.api.parseJsonString(aclTemplateType, aclTemplates);
        }
        if (throwExceptionIfNotPresent) {
            throw new NuageVspApiException((Object)((Object)aclTemplateType) + " ACL corresponding to network " + networkUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
        }
        return null;
    }

    @Override
    public List<NuageVspObject> getACLEntriesAssociatedToLocation(String aclNetworkLocationId, NuageVspEntity aclTemplateType, String aclTemplateId) throws NuageVspApiException {
        NuageVspEntity aclEntryType = null;
        if (aclTemplateType == NuageVspEntity.INGRESS_ACLTEMPLATES) {
            aclEntryType = NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES;
        } else if (aclTemplateType == NuageVspEntity.EGRESS_ACLTEMPLATES) {
            aclEntryType = NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES;
        } else if (aclTemplateType == NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES) {
            aclEntryType = NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES_ENTRIES;
        }
        if (aclEntryType == null) {
            return Collections.emptyList();
        }
        String aclTemplateEntries = null;
        aclTemplateEntries = aclNetworkLocationId != null ? this.api.getResources(aclTemplateType, aclTemplateId, aclEntryType, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId) : this.api.getResources(aclTemplateType, aclTemplateId, aclEntryType, NuageVspFilter.where().field(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE).ne((Object)Acl.AclEntryLocationType.SUBNET));
        if (StringUtils.isNotBlank((String)aclTemplateEntries)) {
            return this.api.parseJsonString(aclEntryType, aclTemplateEntries);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, NuageVspObject> getACLEntriesAssociatedToLocationByExternalId(String aclNetworkLocationId, NuageVspEntity aclTemplateType, String aclTemplateId) throws NuageVspApiException {
        List<NuageVspObject> entries = this.getACLEntriesAssociatedToLocation(aclNetworkLocationId, aclTemplateType, aclTemplateId);
        return this.groupByExternalId(entries);
    }

    @Override
    public void createDefaultRules(VspNetwork vspNetwork, NuageVspEntity nuageVspEntity, String nuageVspEntityId) throws NuageVspApiException {
        String domainTemplateId;
        NuageVspEntity domainTemplateType;
        if (nuageVspEntity == NuageVspEntity.DOMAIN_TEMPLATE || nuageVspEntity == NuageVspEntity.L2DOMAIN_TEMPLATE) {
            domainTemplateType = nuageVspEntity;
            domainTemplateId = nuageVspEntityId;
        } else if (nuageVspEntity == NuageVspEntity.DOMAIN || nuageVspEntity == NuageVspEntity.L2DOMAIN) {
            try {
                NuageVspObject domain = this.api.getResource(nuageVspEntity, nuageVspEntityId);
                domainTemplateId = (String)domain.get(NuageVspAttribute.TEMPLATE_ID);
                domainTemplateType = nuageVspEntity == NuageVspEntity.DOMAIN ? NuageVspEntity.DOMAIN_TEMPLATE : NuageVspEntity.L2DOMAIN_TEMPLATE;
            }
            catch (NuageVspException e) {
                throw NuageVspRestApi.handleException("Failed to create Default Ingress Rules ", e, new Object[0]);
            }
        } else {
            return;
        }
        this.createDefaultIngressAcls(vspNetwork, domainTemplateType, domainTemplateId);
        this.createDefaultEgressAcls(vspNetwork, domainTemplateType, domainTemplateId);
    }

    @Override
    public Pair<NuageVspObject, NuageVspObject> findOrCreateAclTemplates(NetworkDetails networkDetails, Integer priority) throws NuageVspApiException {
        String vpcOrSubnetUuid = networkDetails.getDomainUuid();
        NuageVspEntity domainType = networkDetails.getDomainType();
        String domainId = networkDetails.getDomainId();
        NuageVspObject ingressTemplate = this.findOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainId, NuageVspEntity.INGRESS_ACLTEMPLATES, Acl.AclTemplatePriorityType.NONE, priority);
        NuageVspObject egressTemplate = this.findOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainId, NuageVspEntity.EGRESS_ACLTEMPLATES, Acl.AclTemplatePriorityType.NONE, priority);
        return Pair.of((Object)ingressTemplate, (Object)egressTemplate);
    }

    @Override
    public void saveAclRule(String enterpriseId, VspNetwork network, AclRulesDetails aclRulesDetails, NuageVspAclClient.AclProgress state, VspAclRule vspAclRule) throws NuageVspApiException {
        String oldEntryJson;
        NuageVspEntity oldEntityType;
        NuageVspObject oldParentEntity;
        NuageVspEntity newEntityType;
        NuageVspObject newParentEntity;
        boolean isNetworkAcl = aclRulesDetails.isNetworkAcl();
        String vspSubnetId = aclRulesDetails.getAclNetworkLocationId();
        NuageVspFilter filter = NuageVspFilter.where(NuageVspAttribute.EXTERNAL_ID).eq(vspAclRule.getUuid()).and(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID).eq(vspSubnetId);
        if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Ingress)) {
            newParentEntity = aclRulesDetails.getEgressAclTemplate();
            newEntityType = NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES;
            oldParentEntity = aclRulesDetails.getIngressAclTemplate();
            oldEntityType = NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES;
        } else {
            newParentEntity = aclRulesDetails.getIngressAclTemplate();
            newEntityType = NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES;
            oldParentEntity = aclRulesDetails.getEgressAclTemplate();
            oldEntityType = NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES;
        }
        if (vspAclRule.isAddedNetworkAclRule() && StringUtils.isNotBlank((String)(oldEntryJson = this.api.getResources(oldParentEntity, oldEntityType, filter)))) {
            NuageVspObject oldEntry = this.api.getFirstJsonEntity(oldEntityType, oldEntryJson);
            s_logger.debug("ACS %s rule %s is getting added to network %s but an VSP Ingress rule is with same UUID %s already exists in VSP. This means the existing CS Egress rule type has been modified to CS Ingress. So, delete this rule from VSP and create a new Egress rule", new Object[]{vspAclRule.getTrafficType(), vspAclRule, network.getName(), vspAclRule.getUuid()});
            this.api.deleteQuietly(oldEntry);
        }
        String destVmIp = vspAclRule.getSourceIpAddress();
        String entryJson = this.api.getResources(newParentEntity, newEntityType, filter);
        if (StringUtils.isBlank((String)entryJson)) {
            if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Ingress)) {
                this.createEgressACLEntryInVsp(enterpriseId, newParentEntity, vspAclRule, vspSubnetId, network.getId(), state.successfullyAddedEgressACls);
                if (destVmIp != null) {
                    String debugMsg = "ACS Ingress rule %s is getting added to network %s and it does not exists in VSP. The source IP is %s. Enterprise macro with same source IP network will be either created if its not present in VSP. Then a rule will be created using the macro.";
                    s_logger.debug(debugMsg, vspAclRule, network.getName(), destVmIp);
                } else {
                    String debugMsg = "ACS Ingress rule %s is getting added to network %s and it does not exists in VSP. So, ACL rule is created on the L3 Subnet/L2 Domain with network locationId %s on which the ACL rule is added.";
                    s_logger.debug(debugMsg, vspAclRule, network.getName(), vspSubnetId);
                }
            } else {
                this.createIngressACLEntryInVsp(isNetworkAcl, enterpriseId, newParentEntity, vspAclRule, vspSubnetId, network.getId(), state.successfullyAddedIngressACls);
                String debugMsg = "ACS Egress rule %s is getting added to network %s and it does not exists in VSP. So, ACL rule is created on the L3 Subnet/L2 Domain with network locationId %s on which the ACL rule is added.";
                s_logger.debug(debugMsg, vspAclRule, network.getName(), vspSubnetId);
            }
        } else if (isNetworkAcl) {
            NuageVspObject entry = this.api.getFirstJsonEntity(newEntityType, entryJson);
            String entryId = entry.getId();
            int oldPriority = (Integer)entry.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY);
            if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Ingress)) {
                this.updateEgressACLEntryInVsp(enterpriseId, entryId, entry, vspAclRule, vspSubnetId, network.getId(), oldPriority);
            } else {
                this.updateIngressACLEntryInVsp(enterpriseId, entryId, entry, vspAclRule, vspSubnetId, network.getId(), oldPriority);
            }
        }
    }

    @Override
    public void createOrDeleteDefaultIngressSubnetBlockAcl(VspNetwork vspNetwork, AclRulesDetails aclRulesDetails) throws NuageVspException {
        block7: {
            String networkName = vspNetwork.getName();
            String networkUuid = vspNetwork.getSubnetExternalId();
            try {
                int priority = (int)(10800000L + vspNetwork.getId());
                String defaultIngressAcl = this.api.getResources(NuageVspEntity.INGRESS_ACLTEMPLATES, aclRulesDetails.getIngressAclTemplateId(), NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, priority);
                List<NuageVspObject> ingressAclEntry = this.api.parseJsonString(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, defaultIngressAcl);
                if (aclRulesDetails.isNeedsBlockRule()) {
                    if (!ingressAclEntry.isEmpty()) break block7;
                    try {
                        this.ensureDefaultIngressAclEntry(null, aclRulesDetails.getIngressAclTemplate(), false, Protocol.ANY, Acl.AclAction.DROP, priority, "Default Subnet ACL to block traffic as there is an ACL list associated with it", Acl.AclEntryLocationType.SUBNET, aclRulesDetails.getAclNetworkLocationId(), Acl.AclEntryNetworkType.ANY, networkName, networkUuid);
                        s_logger.debug("Default ACL to block subnets traffic is added with priority " + priority, new Object[0]);
                    }
                    catch (NuageVspApiException e) {
                        if (e.getHttpErrorCode() == 409 && e.getNuageErrorCode() == NuageVspConstants.ErrorCode.DUPLICATE_ACL_PRIORITY) {
                            s_logger.debug("Looks like the ACL Entry with priority " + priority + " already exists. So, it is not re-created", new Object[0]);
                        }
                        break block7;
                    }
                }
                if (!ingressAclEntry.isEmpty()) {
                    s_logger.debug("There are no Egress ACLs added to the network " + networkName + ". So, delete default subnet block ACL", new Object[0]);
                    this.api.deleteQuietly(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, (String)ingressAclEntry.iterator().next().get(NuageVspAttribute.ID));
                }
            }
            catch (NuageVspException e) {
                throw NuageVspRestApi.handleException("Failed to %s default Subnet ACL to block traffic for network %s", e, aclRulesDetails.isNeedsBlockRule() ? "create" : "delete", networkName);
            }
        }
    }

    @Override
    public void removeAclRule(VspNetwork vspNetwork, AclRulesDetails aclRulesDetails, VspAclRule vspAclRule) throws NuageVspException {
        NuageVspFilter filter = NuageVspFilter.where(NuageVspAttribute.EXTERNAL_ID).eq(vspAclRule.getUuid()).and(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID).eq(aclRulesDetails.getAclNetworkLocationId());
        String networkName = vspNetwork.getName();
        if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Egress)) {
            String ingressEntry = this.api.getResources(aclRulesDetails.getIngressAclTemplate(), NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, filter);
            if (StringUtils.isNotBlank((String)ingressEntry)) {
                String ingressEntryId = this.api.getEntityId(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, ingressEntry);
                s_logger.debug("ACS ACL rule " + vspAclRule + " associated to network " + networkName + " is in Revoke state. This ACL " + ingressEntryId + " exists in VSP. So, delete it", new Object[0]);
                this.api.deleteQuietly(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, ingressEntryId);
            } else {
                s_logger.debug("ACS ACL rule " + vspAclRule + " associated to network " + networkName + " is in Revoke state. But, this ACL does not exist in VSP. So, it is ignored", new Object[0]);
            }
        } else if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Ingress)) {
            String egressEntry = this.api.getResources(aclRulesDetails.getEgressAclTemplate(), NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, filter);
            if (StringUtils.isNotBlank((String)egressEntry)) {
                String egressEntryId = this.api.getEntityId(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressEntry);
                this.api.deleteQuietly(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressEntryId);
                s_logger.debug("ACS ACL rule " + vspAclRule + " associated to network " + networkName + " is in Revoke state. This ACL " + egressEntryId + " exists in VSP and it is deleted", new Object[0]);
            } else {
                s_logger.debug("ACS ACL rule " + vspAclRule + " associated to network " + networkName + " is in Revoke state. But, this ACL does not exist in VSP. So, it is ignored", new Object[0]);
            }
        }
    }

    @Override
    public void resetAllAclRulesInTheNetwork(VspNetwork vspNetwork, NetworkDetails networkDetails, AclRulesDetails aclRulesDetails) throws NuageVspException {
        this.createDefaultRules(vspNetwork, networkDetails.getDomainType(), networkDetails.getDomainId());
        this.cleanStaleAclsFromVsp(aclRulesDetails);
    }

    @Override
    public void applyFIPAccessControl(NuageVspEntity domainType, String domainId, String networkUuid, String staticNatIpUuid, boolean accessControl) throws NuageVspApiException {
        String fipExternalId = networkUuid + ":" + staticNatIpUuid;
        try {
            NuageVspObject floatingIp = this.api.getEntityByExternalId(domainType, domainId, NuageVspEntity.FLOATING_IP, fipExternalId);
            if (floatingIp != null) {
                floatingIp.set(NuageVspAttribute.FLOATING_IP_ACCESS_CONTROL, accessControl);
                this.api.updateResource(floatingIp);
            }
        }
        catch (NuageVspException exception) {
            throw NuageVspRestApi.handleException("Failed to apply FIP Access control", exception, new Object[0]);
        }
    }

    @Override
    public void applyStaticRoutes(NetworkDetails networkDetails, Collection<VspStaticRoute> staticRoutes) throws NuageVspApiException {
        try {
            NuageVspObject domain = this.api.getEntityByExternalId(NuageVspEntity.ENTERPRISE, networkDetails.getEnterpriseId(), networkDetails.getDomainType(), networkDetails.getDomainUuid());
            if (domain == null) {
                throw new NuageVspApiException("Domain not found on VSD");
            }
            for (VspStaticRoute staticRoute : staticRoutes) {
                Pair<String, String> subnetNetmask = NetUtils.cidrToSubnetNetmask(staticRoute.getCidr());
                EnumMap filter = Maps.newEnumMap(NuageVspAttribute.class);
                filter.put(NuageVspAttribute.STATIC_ROUTE_ADDRESS, subnetNetmask.getLeft());
                filter.put(NuageVspAttribute.STATIC_ROUTE_NETMASK, subnetNetmask.getRight());
                NuageVspObject entry = this.api.getEntityByExternalId(NuageVspEntity.DOMAIN, domain.getId(), NuageVspEntity.STATIC_ROUTE, staticRoute.getUuid());
                if (entry == null) {
                    if (staticRoute.isRevoke()) continue;
                    entry = this.api.createNuageVspObject(NuageVspEntity.STATIC_ROUTE);
                    entry.set(NuageVspAttribute.STATIC_ROUTE_ADDRESS, subnetNetmask.getLeft());
                    entry.set(NuageVspAttribute.STATIC_ROUTE_NETMASK, subnetNetmask.getRight());
                    entry.set(NuageVspAttribute.STATIC_ROUTE_NEXTHOP, staticRoute.getNextHop());
                    entry.setExternalId(staticRoute.getUuid());
                    this.api.createResource(domain, entry, new NuageVspConstants.ErrorCode[0]);
                    continue;
                }
                if (staticRoute.isRevoke()) {
                    this.api.deleteResource(entry);
                    continue;
                }
                if (staticRoute.getNextHop().equals(entry.get(NuageVspAttribute.STATIC_ROUTE_NEXTHOP))) continue;
                entry.set(NuageVspAttribute.STATIC_ROUTE_ADDRESS, subnetNetmask.getLeft());
                entry.set(NuageVspAttribute.STATIC_ROUTE_NETMASK, subnetNetmask.getRight());
                entry.set(NuageVspAttribute.STATIC_ROUTE_NEXTHOP, staticRoute.getNextHop());
                entry.setExternalId(staticRoute.getUuid());
                this.api.updateResource(entry);
            }
        }
        catch (NuageVspException exception) {
            throw NuageVspRestApi.handleException("Failed to apply static routes", exception, new Object[0]);
        }
    }

    private List<String> cleanStaleAclsFromVsp(AclRulesDetails aclRulesDetails) throws NuageVspException {
        LinkedList<String> cleanedUpVspAclEntries = new LinkedList<String>();
        Consumer<NuageVspObject> deleteQuietly = this.api::deleteQuietly;
        Consumer<NuageVspObject> deleteAndRecord = deleteQuietly.andThen(nvo -> cleanedUpVspAclEntries.add(nvo.getId()));
        String aclNetworkLocationId = aclRulesDetails.getAclNetworkLocationId();
        if (aclRulesDetails.hasIngressRules()) {
            this.getACLEntriesAssociatedToLocationByExternalId(aclNetworkLocationId, NuageVspEntity.EGRESS_ACLTEMPLATES, aclRulesDetails.getEgressAclTemplateId()).values().stream().filter(aclRulesDetails::isMissingIngressRule).forEach(deleteAndRecord);
        }
        if (aclRulesDetails.hasEgressRules()) {
            this.getACLEntriesAssociatedToLocationByExternalId(aclNetworkLocationId, NuageVspEntity.INGRESS_ACLTEMPLATES, aclRulesDetails.getIngressAclTemplateId()).values().stream().filter(aclRulesDetails::isMissingEgressRule).forEach(deleteAndRecord);
        }
        return cleanedUpVspAclEntries;
    }

    private void createDefaultIngressAcls(VspNetwork vspNetwork, NuageVspEntity domainType, String domainId) throws NuageVspApiException {
        String vpcOrSubnetUuid = vspNetwork.getVpcOrSubnetInfo().getLeft();
        String networkName = vspNetwork.getName();
        try {
            NuageVspObject topTemplate = this.findOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainId, NuageVspEntity.INGRESS_ACLTEMPLATES, Acl.AclTemplatePriorityType.TOP, 0);
            NuageVspObject bottomTemplate = this.findOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainId, NuageVspEntity.INGRESS_ACLTEMPLATES, Acl.AclTemplatePriorityType.BOTTOM, 0);
            Map<Integer, NuageVspObject> currentTopAclEntries = this.getDefaultAclEntries(topTemplate);
            Map<Integer, NuageVspObject> currentBottomAclEntries = this.getDefaultAclEntries(bottomTemplate);
            if (vspNetwork.isShared()) {
                this.ensureDefaultIngressAclEntry(currentBottomAclEntries, bottomTemplate, false, Protocol.ANY, Acl.AclAction.FORWARD, 10000001, "Default Allow All", Acl.AclEntryLocationType.ANY, null, Acl.AclEntryNetworkType.ANY, networkName, vpcOrSubnetUuid);
                return;
            }
            this.ensureDefaultIngressAclEntry(currentTopAclEntries, topTemplate, false, Protocol.ANY, Acl.AclAction.FORWARD, 0, "Default Intra-Subnet Allow ACL", Acl.AclEntryLocationType.ANY, null, Acl.AclEntryNetworkType.ENDPOINT_SUBNET, networkName, vpcOrSubnetUuid);
            if (vspNetwork.isVpc() || vspNetwork.isEgressDefaultPolicy()) {
                this.ensureDefaultIngressAclEntry(currentBottomAclEntries, bottomTemplate, true, Protocol.TCP, Acl.AclAction.FORWARD, 1, "Default Allow TCP", Acl.AclEntryLocationType.ANY, null, Acl.AclEntryNetworkType.ANY, networkName, vpcOrSubnetUuid);
                this.ensureDefaultIngressAclEntry(currentBottomAclEntries, bottomTemplate, true, Protocol.UDP, Acl.AclAction.FORWARD, 2, "Default Allow UDP", Acl.AclEntryLocationType.ANY, null, Acl.AclEntryNetworkType.ANY, networkName, vpcOrSubnetUuid);
                this.ensureDefaultIngressAclEntry(currentBottomAclEntries, bottomTemplate, false, Protocol.ICMP, Acl.AclAction.FORWARD, 3, "Default Allow ICMP", Acl.AclEntryLocationType.ANY, null, Acl.AclEntryNetworkType.ANY, networkName, vpcOrSubnetUuid);
            } else {
                this.deleteDefaultAclEntry(currentBottomAclEntries, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, 1);
                this.deleteDefaultAclEntry(currentBottomAclEntries, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, 2);
                this.deleteDefaultAclEntry(currentBottomAclEntries, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, 3);
            }
        }
        catch (NuageVspException exception) {
            throw NuageVspRestApi.handleException("Failed to create default Ingress ACL for network %s", exception, vpcOrSubnetUuid);
        }
    }

    private void createDefaultEgressAcls(VspNetwork vspNetwork, NuageVspEntity domainType, String domainTemplateId) throws NuageVspApiException {
        boolean isVpc = vspNetwork.isVpc();
        String vpcOrSubnetUuid = vspNetwork.getVpcOrSubnetInfo().getLeft();
        boolean egressDefaultAllowPolicy = vspNetwork.isEgressDefaultPolicy();
        String networkName = vspNetwork.getName();
        try {
            NuageVspObject topTemplate = this.findOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainTemplateId, NuageVspEntity.EGRESS_ACLTEMPLATES, Acl.AclTemplatePriorityType.TOP, 0);
            NuageVspObject bottomTemplate = this.findOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainTemplateId, NuageVspEntity.EGRESS_ACLTEMPLATES, Acl.AclTemplatePriorityType.BOTTOM, 0);
            Map<Integer, NuageVspObject> currentTopAclEntries = this.getDefaultAclEntries(topTemplate);
            Map<Integer, NuageVspObject> currentBottomAclEntries = this.getDefaultAclEntries(bottomTemplate);
            if (vspNetwork.isShared()) {
                this.ensureDefaultEgressAclEntry(currentBottomAclEntries, bottomTemplate, false, Protocol.ANY, Acl.AclAction.FORWARD, 10000001, "Default Allow All", Acl.AclEntryNetworkType.ANY, networkName);
                return;
            }
            this.ensureDefaultEgressAclEntry(currentTopAclEntries, topTemplate, false, Protocol.ANY, Acl.AclAction.FORWARD, 0, "Default Intra-Subnet Allow ACL", Acl.AclEntryNetworkType.ENDPOINT_SUBNET, networkName);
            if (isVpc) {
                this.ensureDefaultEgressAclEntry(currentBottomAclEntries, bottomTemplate, false, Protocol.ANY, Acl.AclAction.DROP, 0, "Default Intra-Domain Deny ACL", Acl.AclEntryNetworkType.ENDPOINT_DOMAIN, networkName);
            }
            if (egressDefaultAllowPolicy) {
                this.ensureDefaultEgressAclEntry(currentBottomAclEntries, bottomTemplate, false, Protocol.ICMP, Acl.AclAction.FORWARD, 3, "Default Allow ICMP", Acl.AclEntryNetworkType.ANY, networkName);
            } else {
                this.deleteDefaultAclEntry(currentBottomAclEntries, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, 3);
            }
        }
        catch (NuageVspException exception) {
            throw NuageVspRestApi.handleException("Failed to create default Egress ACL for network %s", exception, vpcOrSubnetUuid);
        }
    }

    private void deleteDefaultAclEntry(Map<Integer, NuageVspObject> currentAclEntries, NuageVspEntity aclType, int aclPriority) {
        if (!currentAclEntries.containsKey(aclPriority)) {
            return;
        }
        NuageVspObject aclEntry = currentAclEntries.get(aclPriority);
        String id = (String)aclEntry.get(NuageVspAttribute.ID);
        this.api.deleteQuietly(aclType, id);
    }

    private void ensureDefaultEgressAclEntry(Map<Integer, NuageVspObject> currentAclEntries, NuageVspObject aclTemplate, boolean isReflexive, Protocol protocol, Acl.AclAction action, int aclPriority, String aclEntryDescription, Acl.AclEntryNetworkType sourceNetwork, String networkName) throws NuageVspException {
        if (currentAclEntries.containsKey(aclPriority)) {
            return;
        }
        NuageVspObject egressACLEntryEntity = this.api.createNuageVspObject(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, Acl.AclEtherType.IPv4);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, (Object)action);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)Acl.AclEntryLocationType.ANY);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)sourceNetwork);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, protocol.getProtocolNumber());
        if (protocol.hasPort()) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, "*");
        }
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, isReflexive);
        egressACLEntryEntity.set(NuageVspAttribute.DESCRIPTION, aclEntryDescription);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, aclPriority);
        NuageVspObject egressACLEntry = this.api.createResource(aclTemplate, egressACLEntryEntity, new NuageVspConstants.ErrorCode[0]);
        currentAclEntries.put(aclPriority, egressACLEntry);
        s_logger.debug("Created Default egressACLTemplateEntry for network " + networkName + " in VSP . Response from VSP is " + egressACLEntry, new Object[0]);
    }

    private void ensureDefaultIngressAclEntry(Map<Integer, NuageVspObject> currentAclEntries, NuageVspObject aclTemplate, boolean isReflexive, Protocol protocol, Acl.AclAction action, int aclPriority, String aclEntryDescription, Acl.AclEntryLocationType locationType, String locationId, Acl.AclEntryNetworkType destinationNetwork, String networkName, String networkUuid) throws NuageVspException {
        if (currentAclEntries != null && currentAclEntries.containsKey(aclPriority)) {
            return;
        }
        NuageVspObject ingressACLEntryEntity = this.api.createNuageVspObject(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, Acl.AclEtherType.IPv4);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, (Object)action);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)locationType);
        if (locationId != null) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, locationId);
        }
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)destinationNetwork);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, protocol.getProtocolNumber());
        if (protocol.hasPort()) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, "*");
        }
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, isReflexive);
        ingressACLEntryEntity.set(NuageVspAttribute.DESCRIPTION, aclEntryDescription);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, aclPriority);
        ingressACLEntryEntity.setExternalId("(" + networkUuid + ")");
        NuageVspObject ingressACLEntry = this.api.createResource(aclTemplate, ingressACLEntryEntity, new NuageVspConstants.ErrorCode[0]);
        if (currentAclEntries != null) {
            currentAclEntries.put(aclPriority, ingressACLEntry);
        }
        s_logger.debug("Created Default IngressACLTemplateEntry for network " + networkName + " in VSP . Response from VSP is " + ingressACLEntry, new Object[0]);
    }

    private String createAclEntry(NuageVspObject aclTemplate, NuageVspEntity aclTemplateEntryType, String vsdEnterpriseId, VspAclRule rule, long networkId, String vspSubnetId) throws NuageVspException {
        boolean isEgress = aclTemplate.getEntityType().equals((Object)NuageVspEntity.EGRESS_ACLTEMPLATES);
        Pair<Acl.AclEntryNetworkType, String> aclEntryNetwork = this.getAclEntryNetworkForCidr(vsdEnterpriseId, rule.getSourceCidrList());
        NuageVspObject aclEntryEntity = isEgress ? this.buildEgressAclEntry(rule, vspSubnetId, networkId, aclEntryNetwork, false, -1) : this.buildIngressAclEntry(rule, vspSubnetId, networkId, aclEntryNetwork, false, -1);
        return this.createAclEntry(aclTemplate, aclTemplateEntryType, aclEntryEntity);
    }

    private String createAclEntry(NuageVspObject aclTemplate, NuageVspEntity aclTemplateEntryType, NuageVspObject aclEntryEntity) throws NuageVspException {
        NuageVspObject aclEntryJson = this.api.createResource(aclTemplate, aclEntryEntity, NuageVspConstants.ErrorCode.DUPLICATE_ACL_PRIORITY);
        s_logger.debug("Created " + (Object)((Object)aclTemplateEntryType) + " ACL Entry in VSP. Response from VSP is " + aclEntryJson, new Object[0]);
        return aclEntryJson.getId();
    }

    private void createEgressACLEntryInVsp(String vsdEnterpriseId, NuageVspObject egressAclTemplate, VspAclRule rule, String vspSubnetId, long networkId, List<String> successfullyAddedEgressACls) throws NuageVspApiException {
        try {
            String egressAclEntryId = this.createAclEntry(egressAclTemplate, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, vsdEnterpriseId, rule, networkId, vspSubnetId);
            successfullyAddedEgressACls.add(egressAclEntryId);
        }
        catch (NuageVspException exception) {
            throw NuageVspRestApi.handleException("Failed to create Egress ACL Entry for rule %s in VSP enterprise %s)", exception, rule, vsdEnterpriseId);
        }
    }

    private void createIngressACLEntryInVsp(boolean isNetworkAcl, String vsdEnterpriseId, NuageVspObject ingressAclTemplate, VspAclRule rule, String aclNetworkLocationId, long networkId, List<String> successfullyAddedIngressACls) throws NuageVspApiException {
        Pair<Acl.AclEntryNetworkType, String> aclEntryNetwork = this.getAclEntryNetworkForCidr(vsdEnterpriseId, rule.getSourceCidrList());
        try {
            String ingressAclEntryId = this.createAclEntry(ingressAclTemplate, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, vsdEnterpriseId, rule, networkId, aclNetworkLocationId);
            successfullyAddedIngressACls.add(ingressAclEntryId);
        }
        catch (NuageVspException exception) {
            throw NuageVspRestApi.handleException("Failed to create Ingress ACL Entry for rule %s with CIDR %s in VSP enterprise %s. ", exception, rule, rule.getSourceCidrList(), vsdEnterpriseId);
        }
    }

    private boolean isModified(NuageVspObject origRule, NuageVspObject newRule) {
        return !origRule.entriesEqualTo(newRule);
    }

    private void updateIngressACLEntryInVsp(String vsdEnterpriseId, String ingressAclEntryId, NuageVspObject ingressEntryData, VspAclRule rule, String aclNetworkLocationId, long networkId, int oldPriority) throws NuageVspApiException {
        block3: {
            Pair<Acl.AclEntryNetworkType, String> aclEntryNetwork = this.getAclEntryNetworkForCidr(vsdEnterpriseId, rule.getSourceCidrList());
            try {
                NuageVspObject modifiedIngressACLEntryEntity = this.buildIngressAclEntryByCidr(vsdEnterpriseId, rule, aclNetworkLocationId, networkId, rule.getSourceCidrList(), true, oldPriority);
                if (this.isModified(modifiedIngressACLEntryEntity, ingressEntryData)) {
                    modifiedIngressACLEntryEntity.setId(ingressEntryData.getId());
                    String ingressAclEntryJson = this.api.updateResource(modifiedIngressACLEntryEntity);
                    s_logger.debug("Updated Ingress ACL Entry for rule " + rule + " with CIDR " + rule.getSourceCidrList() + " in VSP. Response from VSP is " + ingressAclEntryJson, new Object[0]);
                }
            }
            catch (NuageVspException exception) {
                if (exception.isNoChangeInEntityException()) break block3;
                throw NuageVspRestApi.handleException("Failed to Modify Ingress ACL Entry for rule %s with CIDR %s in VSP enterprise %s. ", exception, rule, rule.getSourceCidrList(), vsdEnterpriseId);
            }
        }
    }

    private void updateEgressACLEntryInVsp(String vsdEnterpriseId, String egressAclEntryId, NuageVspObject egressEntryData, VspAclRule rule, String aclNetworkLocationId, long networkId, int oldPriority) throws NuageVspApiException {
        block3: {
            try {
                NuageVspObject modifiedEgressACLEntryEntity = this.buildEgressAclEntryByCidr(vsdEnterpriseId, rule, aclNetworkLocationId, networkId, true, oldPriority);
                if (this.isModified(modifiedEgressACLEntryEntity, egressEntryData)) {
                    modifiedEgressACLEntryEntity.setId(egressEntryData.getId());
                    String ingressAclEntryJson = this.api.updateResource(modifiedEgressACLEntryEntity);
                    s_logger.debug("Updated Ingress ACL Entry for rule %s with CIDR %s in VSP. Response from VSP is %s", rule, rule.getSourceCidrList(), ingressAclEntryJson);
                }
            }
            catch (NuageVspException exception) {
                if (exception.isNoChangeInEntityException()) break block3;
                throw NuageVspRestApi.handleException("Failed to Modify Egress ACL Entry for rule %s with CIDR %s in VSP enterprise %s. ", exception, rule, rule.getSourceCidrList(), vsdEnterpriseId);
            }
        }
    }

    private NuageVspObject buildEgressAclEntryByCidr(String vsdEnterpriseId, VspAclRule rule, String aclNetworkLocationId, long networkId, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        Pair<Acl.AclEntryNetworkType, String> aclEntryNetwork = null;
        if (rule.getType().equals((Object)VspAclRule.ACLType.NetworkACL)) {
            aclEntryNetwork = this.getAclEntryNetworkForCidr(vsdEnterpriseId, rule.getSourceCidrList());
        }
        return this.buildEgressAclEntry(rule, aclNetworkLocationId, networkId, aclEntryNetwork, isUpdate, oldPriority);
    }

    private NuageVspObject buildIngressAclEntryByCidr(String vsdEnterpriseId, VspAclRule rule, String aclNetworkLocationId, long networkId, List<String> sourceCidrList, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        Pair<Acl.AclEntryNetworkType, String> aclEntryNetwork = null;
        if (rule.getType().equals((Object)VspAclRule.ACLType.NetworkACL)) {
            aclEntryNetwork = this.getAclEntryNetworkForCidr(vsdEnterpriseId, sourceCidrList);
        }
        return this.buildIngressAclEntry(rule, aclNetworkLocationId, networkId, aclEntryNetwork, isUpdate, oldPriority);
    }

    private NuageVspObject buildIngressAclEntryBySubnet(VspAclRule rule, String aclNetworkLocationId, long networkId, String vsdSubnetId, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        Pair aclEntryNetwork = Pair.of((Object)((Object)Acl.AclEntryNetworkType.SUBNET), (Object)vsdSubnetId);
        return this.buildIngressAclEntry(rule, aclNetworkLocationId, networkId, (Pair<Acl.AclEntryNetworkType, String>)aclEntryNetwork, isUpdate, oldPriority);
    }

    private NuageVspObject buildEgressAclEntry(VspAclRule rule, String aclNetworkLocationId, long networkId, Pair<Acl.AclEntryNetworkType, String> aclEntryNetwork, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        NuageVspObject egressACLEntryEntity = this.api.createNuageVspObject(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, Acl.AclEtherType.IPv4);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, (Object)(rule.getAction().equals((Object)VspAclRule.ACLAction.Allow) ? Acl.AclAction.FORWARD : Acl.AclAction.DROP));
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, rule.getProtocol().getProtocolNumber());
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        egressACLEntryEntity.setExternalId(rule.getUuid());
        rule = this.updatePriorityForAcl(rule, networkId, isUpdate, oldPriority);
        if (rule.getPriority() < 0 || rule.getPriority() >= 10000000) {
            String error = "Rule number " + rule.getPriority() + " can not be greater than " + 10000000 + " as it is used as rule numbers for predefined rules in VSP";
            s_logger.error((Object)error, new Object[0]);
            throw new NuageVspApiException(error);
        }
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, rule.getPriority());
        if (rule.getSourceIpAddress() != null) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, rule.getSourceIpAddress());
        }
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)Acl.AclEntryLocationType.SUBNET);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId);
        if (aclEntryNetwork != null) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, aclEntryNetwork.getLeft());
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, aclEntryNetwork.getRight());
        }
        if (rule.getProtocol().hasPort()) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, rule.getPortRange());
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
        }
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, rule.isReflexive());
        return egressACLEntryEntity;
    }

    private NuageVspObject buildIngressAclEntry(VspAclRule rule, String aclNetworkLocationId, long networkId, Pair<Acl.AclEntryNetworkType, String> aclEntryNetwork, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        NuageVspObject ingressACLEntryEntity = this.api.createNuageVspObject(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, Acl.AclEtherType.IPv4);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, (Object)(rule.getAction().equals((Object)VspAclRule.ACLAction.Allow) ? Acl.AclAction.FORWARD : Acl.AclAction.DROP));
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, rule.getProtocol().getProtocolNumber());
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        ingressACLEntryEntity.setExternalId(rule.getUuid());
        rule = this.updatePriorityForAcl(rule, networkId, isUpdate, oldPriority);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, rule.getPriority());
        if (rule.getType().equals((Object)VspAclRule.ACLType.Firewall)) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, Joiner.on((String)",").join(rule.getSourceCidrList()));
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)Acl.AclEntryNetworkType.ANY);
        } else if (aclEntryNetwork != null) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, aclEntryNetwork.getLeft());
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, aclEntryNetwork.getRight());
        }
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)Acl.AclEntryLocationType.SUBNET);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId);
        if (rule.getProtocol().hasPort()) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, rule.getPortRange());
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
        }
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, rule.isReflexive());
        return ingressACLEntryEntity;
    }

    private VspAclRule updatePriorityForAcl(VspAclRule rule, long networkId, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        int newPriority;
        switch (rule.getType()) {
            case NetworkACL: {
                if (rule.getPriority() > 9999) {
                    String error = "Rule number can not be greater than 9999 as it is used to generate a unique rule per tier in VSP";
                    s_logger.error((Object)error, new Object[0]);
                    throw new NuageVspApiException(error);
                }
                newPriority = Integer.valueOf(String.valueOf(networkId) + String.valueOf(rule.getPriority()));
                break;
            }
            default: {
                newPriority = isUpdate ? oldPriority : this.getRandomPriority();
            }
        }
        return new VspAclRule.Builder().fromObject(rule).priority(newPriority).build();
    }

    private int getRandomPriority() {
        return (int)(RANDOM.nextDouble() * 99999.0) % 1000000 + 1;
    }

    private Pair<Acl.AclEntryNetworkType, String> getAclEntryNetworkForCidr(String vsdEnterpriseId, List<String> sourceCidrList) throws NuageVspApiException {
        if (FluentIterable.from(sourceCidrList).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String cidr) {
                return cidr.endsWith("/0");
            }
        })) {
            return Pair.of((Object)((Object)Acl.AclEntryNetworkType.ANY), null);
        }
        if (sourceCidrList.size() > 1) {
            if (this.api.vspHost.getApiVersion() == NuageVspApiVersion.V3_2) {
                throw new NuageVspApiException("Multiple CIDRs are not supported in VSP 3.2");
            }
            String groupId = this.findOrCreateNetworkMacroGroup(vsdEnterpriseId, Joiner.on((String)", ").join(sourceCidrList));
            return Pair.of((Object)((Object)Acl.AclEntryNetworkType.NETWORK_MACRO_GROUP), (Object)groupId);
        }
        String macroId = this.findOrCreateNetworkMacro(vsdEnterpriseId, sourceCidrList.get(0));
        return Pair.of((Object)((Object)Acl.AclEntryNetworkType.ENTERPRISE_NETWORK), (Object)macroId);
    }

    public String findOrCreateNetworkMacroGroup(String vsdEnterpriseId, String sourceCidrList) throws NuageVspApiException {
        try {
            TreeSet<String> macroIds = new TreeSet<String>();
            for (String sourceCidr : sourceCidrList.split(",\\s*")) {
                String macroId = this.findOrCreateNetworkMacro(vsdEnterpriseId, sourceCidr);
                macroIds.add(macroId);
            }
            String networkMacroGroupUuid = UuidUtils.generateUuidFromCidr(sourceCidrList, null);
            NuageVspObject group = this.api.getEntityByExternalId(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, NuageVspEntity.ENTERPRISE_NTWK_MACRO_GROUP, networkMacroGroupUuid);
            if (group == null) {
                NuageVspObject macroEntity = this.api.createNuageVspObject(NuageVspEntity.ENTERPRISE_NTWK_MACRO_GROUP);
                macroEntity.set(NuageVspAttribute.NAME, "CIDR List" + networkMacroGroupUuid);
                macroEntity.set(NuageVspAttribute.DESCRIPTION, sourceCidrList);
                macroEntity.setExternalId(networkMacroGroupUuid);
                group = this.api.createResource(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, macroEntity);
                this.api.setRelatedEntities(group, NuageVspEntity.ENTERPRISE_NTWK_MACRO, macroIds);
            }
            return group.getId();
        }
        catch (NuageVspException exception) {
            throw NuageVspRestApi.handleException("Failed to read Public network macro Group %s in VSP enterprise %s.  Json response from VSP REST API is  %s", exception, sourceCidrList, vsdEnterpriseId, exception.getMessage());
        }
    }

    public String findOrCreateNetworkMacro(String vsdEnterpriseId, String sourceCidr) throws NuageVspApiException {
        try {
            Pair<String, String> subnetmask = NetUtils.cidrToSubnetNetmask(sourceCidr);
            String macroJsonString = this.api.getResources(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, NuageVspEntity.ENTERPRISE_NTWK_MACRO, NuageVspFilter.where().field(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_ADDRESS).eq(subnetmask.getLeft()).and().field(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NETMASK).eq(subnetmask.getRight()));
            if (StringUtils.isBlank((String)macroJsonString)) {
                String networkMacroUuid = UuidUtils.generateUuidFromCidr(sourceCidr);
                NuageVspObject macroEntity = this.api.createNuageVspObject(NuageVspEntity.ENTERPRISE_NTWK_MACRO);
                macroEntity.set(NuageVspAttribute.NAME, "CIDR " + sourceCidr.replace('.', ' ').replace("/", " - "));
                macroEntity.set(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_ADDRESS, subnetmask.getLeft());
                macroEntity.set(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NETMASK, subnetmask.getRight());
                macroEntity.setExternalId(networkMacroUuid);
                NuageVspObject macro = this.api.createResource(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, macroEntity);
                s_logger.debug("Created Enterprise Network Macro in VSP. Response from VSP is " + macro, new Object[0]);
                return macro.getId();
            }
            return this.api.getEntityId(NuageVspEntity.ENTERPRISE_NTWK_MACRO, macroJsonString);
        }
        catch (NuageVspException exception) {
            throw NuageVspRestApi.handleException("Failed to read Public network macro %s in VSP enterprise %s.  Json response from VSP REST API is  %s", exception, sourceCidr, vsdEnterpriseId, exception.getMessage());
        }
    }

    public Map<String, NuageVspObject> groupByExternalId(List<NuageVspObject> aclEntries) {
        HashMap<String, NuageVspObject> externalUuidToAcl = new HashMap<String, NuageVspObject>();
        for (NuageVspObject entry : aclEntries) {
            String externalUuid = entry.getExternalId();
            if (externalUuid == null) continue;
            externalUuidToAcl.put(externalUuid, entry);
        }
        return externalUuidToAcl;
    }

    public Map<Integer, NuageVspObject> getDefaultAclEntries(NuageVspObject aclTemplate) throws NuageVspException {
        List<NuageVspObject> defaultVspAclEntries = this.getACLEntriesAssociatedToLocation(null, aclTemplate.getEntityType(), aclTemplate.getId());
        HashMap<Integer, NuageVspObject> aclPriorityToEntry = new HashMap<Integer, NuageVspObject>();
        for (NuageVspObject aclEntry : defaultVspAclEntries) {
            Integer priority = (Integer)aclEntry.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY);
            aclPriorityToEntry.put(priority, aclEntry);
        }
        return aclPriorityToEntry;
    }
}

