/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.nuage.vsp.acs.client.api.NuageVspAclClient;
import net.nuage.vsp.acs.client.api.NuageVspApiClient;
import net.nuage.vsp.acs.client.api.NuageVspElementClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspClientImpl;
import net.nuage.vsp.acs.client.api.model.VspAclRule;
import net.nuage.vsp.acs.client.api.model.VspDhcpDomainOption;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.VspStaticNat;
import net.nuage.vsp.acs.client.common.model.AclRulesDetails;
import net.nuage.vsp.acs.client.common.model.Dhcp;
import net.nuage.vsp.acs.client.common.model.DhcpOption;
import net.nuage.vsp.acs.client.common.model.DhcpOptions;
import net.nuage.vsp.acs.client.common.model.NetworkDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspFilter;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import net.nuage.vsp.acs.client.exception.NuageVspUnsupportedRequestException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;

public class NuageVspElementClientImpl
extends NuageVspClientImpl
implements NuageVspElementClient {
    private final Logger s_logger = new Logger(NuageVspElementClientImpl.class);

    public NuageVspElementClientImpl(NuageVspApiClient nuageVspApiClient, NuageVspAclClient nuageVspAclClient) {
        super(nuageVspApiClient, nuageVspAclClient);
    }

    @Override
    public boolean implement(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions, List<VspAclRule> ingressFirewallRules, List<VspAclRule> egressFirewallRules, List<String> floatingIpUuids) throws NuageVspException {
        block10: {
            NetworkDetails attachedNetworkDetails;
            try {
                attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
            }
            catch (NuageVspApiException exception) {
                this.s_logger.error((Object)("Exception occurred while executing implement API. So, FIP clean up could not be execued successfully. Retry restarting the network " + vspNetwork.getName()), new Object[0]);
                return true;
            }
            this.s_logger.debug("Starting the sync for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
            if (!vspNetwork.isVpc() && vspNetwork.isFirewallServiceSupported()) {
                this.s_logger.debug("Started Sync Ingress Firewall Rule for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
                this.applyAclRules(VspAclRule.ACLType.Firewall, vspNetwork, ingressFirewallRules, false);
                this.s_logger.debug("Finished Sync Ingress Firewall Rule for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
                this.s_logger.debug("Started Sync Egress Firewall Rule for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
                this.applyAclRules(VspAclRule.ACLType.Firewall, vspNetwork, egressFirewallRules, false);
                this.s_logger.debug("Finished Sync Egress Firewall Rule for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
            }
            this.s_logger.debug("Started Sync of Static NAT for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
            try {
                this.updateDhcpOptions(vspNetwork, vspDhcpOptions, attachedNetworkDetails);
                NuageVspFilter fipExternalIdFilter = NuageVspFilter.where().field(NuageVspAttribute.EXTERNAL_ID).startsWith(attachedNetworkDetails.getDomainUuid());
                String floatingIpsAssoToNetwork = this.nuageVspApiClient.findEntityUsingFilter(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), NuageVspEntity.FLOATING_IP, fipExternalIdFilter);
                if (vspNetwork.isPublicAccess() || !StringUtils.isNotBlank((String)floatingIpsAssoToNetwork)) break block10;
                List<NuageVspObject> fips = this.nuageVspApiClient.parseJsonString(NuageVspEntity.FLOATING_IP, floatingIpsAssoToNetwork);
                for (NuageVspObject fip : fips) {
                    String fipId = fip.getId();
                    String externalId = fip.getExternalId();
                    String fipIp = (String)fip.get(NuageVspAttribute.FLOATING_IP_ADDRESS);
                    if (floatingIpUuids.contains(externalId.substring(externalId.indexOf(":") + 1))) continue;
                    this.s_logger.debug("Floating IP " + fipIp + " with " + externalId + " does not exists in ACS network " + vspNetwork.getName() + ". So, processing to clean the stale FIP from VSP", new Object[0]);
                    String vportJson = null;
                    try {
                        vportJson = this.nuageVspApiClient.getResources(fip, NuageVspEntity.VPORT);
                    }
                    catch (NuageVspApiException e) {
                        this.s_logger.debug("Failed to get VPorts from VSP during FIP clean up. " + e.getMessage(), new Object[0]);
                    }
                    if (StringUtils.isNotBlank((String)vportJson)) {
                        List<NuageVspObject> vports = this.nuageVspApiClient.parseJsonString(NuageVspEntity.VPORT, vportJson);
                        for (NuageVspObject vport : vports) {
                            if (!StringUtils.equals((String)((String)vport.get(NuageVspAttribute.VPORT_FLOATING_IP_ID)), (String)fipId)) continue;
                            String vportId = (String)vport.get(NuageVspAttribute.ID);
                            this.nuageVspApiClient.updateVPortWithFloatingIPId(vportId, null);
                            this.s_logger.debug("Found a VPort " + vport + " that is associated the stale FIP in network " + vspNetwork.getName() + ". Removed the association to clean the FIP " + fipIp, new Object[0]);
                        }
                    }
                    this.s_logger.debug("Clean the stale FIP " + fipIp + " associated to network " + vspNetwork.getName() + " from VSP", new Object[0]);
                    this.nuageVspApiClient.deleteQuietly(NuageVspEntity.FLOATING_IP, fipId);
                }
            }
            catch (NuageVspApiException exception) {
                this.s_logger.error((Object)("Exception occurred while executing implement API. So, FIP clean up could not be execued successfully. Retry restarting the network " + vspNetwork.getName()), new Object[0]);
                return false;
            }
        }
        return true;
    }

    private boolean usesPreconfiguredDomainTemplate(String enterpriseId, String networkUuid, String domainTemplateName) throws NuageVspException {
        String networkDomainTemplateId = (String)this.nuageVspApiClient.findFieldValueByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, networkUuid, NuageVspAttribute.TEMPLATE_ID);
        String domainTemplateEntity = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, NuageVspAttribute.NAME, domainTemplateName);
        String domainTemplateId = this.nuageVspApiClient.getEntityId(domainTemplateEntity, NuageVspEntity.DOMAIN_TEMPLATE);
        return StringUtils.isNotBlank((String)networkDomainTemplateId) && StringUtils.isNotBlank((String)domainTemplateId) && networkDomainTemplateId.equals(domainTemplateId);
    }

    @Override
    public void applyStaticNats(VspNetwork vspNetwork, List<VspStaticNat> vspStaticNats) throws NuageVspException {
        NetworkDetails attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
        for (VspStaticNat vspStaticNat : vspStaticNats) {
            String vspNicSecondaryIpUuid;
            String vspNicUuid = vspStaticNat.getVspNic() != null ? vspStaticNat.getVspNic().getUuid() : null;
            String string = vspNicSecondaryIpUuid = vspStaticNat.getVspNic() != null ? vspStaticNat.getVspNic().getSecondaryIpUuid() : null;
            if (vspStaticNat.getVspNic() != null && vspStaticNat.getVspNic().getMacAddress() == null && vspStaticNat.getRevoke() == Boolean.TRUE) {
                this.s_logger.debug("VM is getting deleted with out disabling the Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + "). So, floating IP is disassociated from VM and is deleted from VSP", new Object[0]);
                this.nuageVspApiClient.releaseFIPFromVsp(attachedNetworkDetails, null, vspStaticNat.getIpUuid(), vspNicSecondaryIpUuid);
                continue;
            }
            String vportId = this.nuageVspApiClient.findEntityIdByExternalUuid(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), NuageVspEntity.VPORT, vspNicUuid);
            if (vspStaticNat.getRevoke() == Boolean.TRUE) {
                this.s_logger.debug("Static NAT %s (%s) is deleted from the VM. So, disassociate the Floating IP from VM's VPort %s and delete the Floating IP", vspStaticNat.getIpAddress(), vspStaticNat.getIpUuid(), vportId);
                this.nuageVspApiClient.releaseFIPFromVsp(attachedNetworkDetails, vportId, vspStaticNat.getIpUuid(), vspNicSecondaryIpUuid);
                continue;
            }
            this.s_logger.debug("Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + ") is associated to the VM. So, create a new Floating IP " + vspStaticNat.getIpAddress() + " and associate it to VM with VPort " + vportId, new Object[0]);
            this.nuageVspApiClient.applyStaticNatInVsp(attachedNetworkDetails, vportId, vspStaticNat);
        }
    }

    @Override
    public void applyAclRules(VspAclRule.ACLType vspAclRuleType, VspNetwork vspNetwork, List<VspAclRule> vspAclRules, boolean networkReset) throws NuageVspException {
        NetworkDetails attachedNetworkDetails;
        int random = RandomUtils.nextInt((int)1000);
        long initialStartTime = System.currentTimeMillis();
        Boolean ingressFirewallRules = null;
        if (vspAclRules == null) {
            vspAclRules = Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty((Collection)vspAclRules) && vspAclRuleType == VspAclRule.ACLType.Firewall) {
            ingressFirewallRules = ((VspAclRule)vspAclRules.get(0)).getTrafficType() == VspAclRule.ACLTrafficType.Ingress;
        }
        try {
            attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
        }
        catch (NuageVspException e) {
            this.s_logger.debug("Enterprise or Domain does not exists in VSP. So, ACLs update is ignored for network " + vspNetwork.getName() + ". " + e.getMessage(), new Object[0]);
            return;
        }
        boolean usesPreConfiguredDomainTemplate = this.usesPreconfiguredDomainTemplate(attachedNetworkDetails.getEnterpriseId(), attachedNetworkDetails.getDomainUuid(), vspNetwork.getDomainTemplateName());
        if (usesPreConfiguredDomainTemplate) {
            if (CollectionUtils.isNotEmpty((Collection)vspAclRules)) {
                for (VspAclRule rule : vspAclRules) {
                    if (rule.getState() == VspAclRule.ACLState.Revoke) continue;
                    this.s_logger.info("CloudStack ACLs are not supported with Nuage Preconfigured Domain Template", new Object[0]);
                    throw new NuageVspUnsupportedRequestException("CloudStack ACLs are not supported with Nuage Preconfigured Domain Template");
                }
            }
            return;
        }
        if (StringUtils.isNotBlank((String)attachedNetworkDetails.getDomainId())) {
            Pair<NuageVspObject, NuageVspObject> aclTemplates = this.nuageVspAclClient.findOrCreateAclTemplates(attachedNetworkDetails, 1);
            NuageVspObject ingressAclTemplate = (NuageVspObject)aclTemplates.getLeft();
            NuageVspObject egressAclTemplate = (NuageVspObject)aclTemplates.getRight();
            String aclNetworkLocationId = attachedNetworkDetails.getSubnetId();
            if (!StringUtils.isBlank((String)aclNetworkLocationId)) {
                AclRulesDetails aclRulesDetails = new AclRulesDetails(vspAclRules, vspAclRuleType == VspAclRule.ACLType.NetworkACL, ingressFirewallRules, true, aclNetworkLocationId, ingressAclTemplate, egressAclTemplate);
                if (networkReset) {
                    this.s_logger.debug("Network is restarted to just cleanup the stale ACL rules and checking for default rules for " + vspNetwork.getName(), new Object[0]);
                    this.nuageVspAclClient.resetAllAclRulesInTheNetwork(vspNetwork, attachedNetworkDetails, aclRulesDetails);
                    return;
                }
                if (ingressAclTemplate != null && egressAclTemplate != null) {
                    this.updateACLEntriesInVsp(attachedNetworkDetails, vspNetwork, aclRulesDetails);
                }
                this.s_logger.debug("Network " + vspNetwork.getName() + "(" + random + ")   total time taken to process this thread with " + vspAclRules.size() + " rules is " + (System.currentTimeMillis() - initialStartTime), new Object[0]);
            } else {
                this.s_logger.debug("VSP subnet corresponding to network " + vspNetwork.getName() + " is not found. So, skipping ACL application", new Object[0]);
            }
        }
    }

    private void updateACLEntriesInVsp(NetworkDetails attachedNetworkDetails, VspNetwork vspNetwork, AclRulesDetails aclRulesDetails) throws NuageVspException {
        NuageVspAclClient.AclProgress aclProgress = new NuageVspAclClient.AclProgress();
        String enterpriseId = attachedNetworkDetails.getEnterpriseId();
        if (aclRulesDetails.isAllRulesActive()) {
            this.s_logger.debug("All rules are in in Active state. This is a ACLList replace scenario or Network Restart. So, processing the ACL lists.", new Object[0]);
            this.nuageVspAclClient.resetAllAclRulesInTheNetwork(vspNetwork, attachedNetworkDetails, aclRulesDetails);
            for (VspAclRule vspAclRule : aclRulesDetails.getVspAclRules()) {
                this.nuageVspAclClient.saveAclRule(enterpriseId, vspNetwork, aclRulesDetails, aclProgress, vspAclRule);
            }
        } else {
            for (VspAclRule vspAclRule : aclRulesDetails.getVspAclRules()) {
                switch (vspAclRule.getState()) {
                    case Add: {
                        this.nuageVspAclClient.saveAclRule(enterpriseId, vspNetwork, aclRulesDetails, aclProgress, vspAclRule);
                        break;
                    }
                    case Revoke: {
                        this.nuageVspAclClient.removeAclRule(vspNetwork, aclRulesDetails, vspAclRule);
                    }
                }
            }
        }
        if (aclRulesDetails.isNetworkAcl()) {
            this.nuageVspAclClient.createOrDeleteDefaultIngressSubnetBlockAcl(vspNetwork, aclRulesDetails);
        }
    }

    @Override
    public boolean shutdownNetwork(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) {
        try {
            NetworkDetails attachedNetworkDetails = this.getAttachedNetworkDetails(false, vspNetwork);
            if (attachedNetworkDetails == null) {
                this.s_logger.debug("The network details corresponding to network " + vspNetwork.getUuid() + " could not be found.", new Object[0]);
                return true;
            }
            this.updateDhcpOptions(vspNetwork, vspDhcpOptions, attachedNetworkDetails);
        }
        catch (NuageVspException e) {
            this.s_logger.error((Object)("Exception occurred while executing shutdown network API. name: " + vspNetwork.getName()), new Object[0]);
            return false;
        }
        return true;
    }

    private void updateDhcpOptions(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions, NetworkDetails attachedNetworkDetails) throws NuageVspException {
        if (vspDhcpOptions != null && !vspNetwork.isL2()) {
            try {
                this.s_logger.debug("Started Sync of DNS Server setting for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
                DhcpOptions dhcpOptions = vspDhcpOptions.getVrIsDnsProvider() != false ? new DhcpOptions(vspNetwork.getVirtualRouterIp(), vspDhcpOptions.getDnsServers(), vspDhcpOptions.getNetworkDomain()) : new DhcpOptions(null, vspDhcpOptions.getDnsServers(), null);
                this.nuageVspApiClient.createDhcpOptions(NuageVspApiClient.ExistingDhcpOptionStrategy.FETCH_AND_DELETE, attachedNetworkDetails, vspNetwork, dhcpOptions);
            }
            catch (NuageVspException e1) {
                this.s_logger.warn("Failed to update the DNS Server information for network " + vspNetwork.getName(), new Object[0]);
            }
            this.s_logger.debug("Finished Sync of DNS Server setting for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
        }
    }

    @Override
    public void shutdownVpc(String domainUuid, String vpcUuid, String domainTemplateName, List<String> domainRouterUuids) throws NuageVspException {
        String enterpriseId = this.nuageVspApiClient.getEnterprise(domainUuid);
        if (StringUtils.isNotBlank((String)enterpriseId)) {
            String vspNetworkId;
            if (CollectionUtils.isNotEmpty(domainRouterUuids)) {
                for (String domainRouterUuid : domainRouterUuids) {
                    NuageVspObject domainRouter = this.nuageVspApiClient.getVMDetails(domainRouterUuid);
                    if (domainRouter == null) continue;
                    String vmId = (String)domainRouter.get(NuageVspAttribute.ID);
                    this.nuageVspApiClient.deleteVM(domainRouterUuid, vmId);
                    this.s_logger.debug("VR " + domainRouterUuid + " in VPC " + vpcUuid + " is deleted as the VPC is deleted", new Object[0]);
                }
            }
            String domainTemplateId = (String)this.nuageVspApiClient.findFieldValueByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, vpcUuid, NuageVspAttribute.TEMPLATE_ID);
            String vpcDomainTemplateEntity = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, NuageVspAttribute.NAME, domainTemplateName);
            String currentPredefinedDomTplId = this.nuageVspApiClient.getEntityId(vpcDomainTemplateEntity, NuageVspEntity.DOMAIN_TEMPLATE);
            if (domainTemplateId == null) {
                return;
            }
            if (domainTemplateId.equals(currentPredefinedDomTplId)) {
                vspNetworkId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, vpcUuid);
                if (StringUtils.isNotBlank((String)vspNetworkId)) {
                    this.s_logger.debug("Deleting VPC " + vpcUuid + " from VSP", new Object[0]);
                    this.nuageVspApiClient.deleteQuietly(NuageVspEntity.DOMAIN, vspNetworkId);
                }
            } else {
                vspNetworkId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, vpcUuid);
                if (StringUtils.isNotBlank((String)vspNetworkId)) {
                    this.s_logger.debug("Deleting VPC " + vpcUuid + " from VSP", new Object[0]);
                    this.nuageVspApiClient.deleteQuietly(NuageVspEntity.DOMAIN_TEMPLATE, vspNetworkId);
                } else {
                    vspNetworkId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, vpcUuid);
                    if (StringUtils.isNotBlank((String)vspNetworkId)) {
                        this.s_logger.debug("Deleting VPC " + vpcUuid + " from VSP", new Object[0]);
                        this.nuageVspApiClient.deleteQuietly(NuageVspEntity.DOMAIN, vspNetworkId);
                    }
                }
            }
        }
    }

    @Override
    public void setDhcpOptionsNic(VspNetwork vspNetwork, String nicUuid, Map<Integer, String> extraDhcpOptions) throws NuageVspException {
        DhcpOptions dhcpOptionsToApply = this.extractDhcpOptions(extraDhcpOptions);
        NetworkDetails attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
        String vportVsdId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.SUBNET, attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, nicUuid);
        this.nuageVspApiClient.removeAllDhcpOptionsWithCode(NuageVspEntity.VPORT, nicUuid, vportVsdId, dhcpOptionsToApply.getOptionsToBeRemoved());
        this.nuageVspApiClient.createDhcpOptions(NuageVspApiClient.ExistingDhcpOptionStrategy.FETCH, NuageVspEntity.VPORT, nicUuid, vportVsdId, vspNetwork, dhcpOptionsToApply);
    }

    private DhcpOptions extractDhcpOptions(Map<Integer, String> actualDhcpOptions) {
        DhcpOptions toBeAddedDhcpOptions = new DhcpOptions();
        Set supportedDhcpCodes = Dhcp.dhcpCodeToType.keySet().stream().map(Dhcp.DhcpOptionCode::getCode).collect(Collectors.toSet());
        Set defaultDhcpCodes = Dhcp.defaultDhcpOptions.stream().map(Dhcp.DhcpOptionCode::getCode).collect(Collectors.toSet());
        if (!Sets.difference(actualDhcpOptions.keySet(), supportedDhcpCodes).isEmpty() || !Sets.intersection(actualDhcpOptions.keySet(), defaultDhcpCodes).isEmpty()) {
            throw new IllegalArgumentException("Unsupported DHCP option specified.");
        }
        for (Integer dhcpCode : actualDhcpOptions.keySet()) {
            String dhcpCurrentCodeOption = actualDhcpOptions.get(dhcpCode);
            if (StringUtils.isNotBlank((String)dhcpCurrentCodeOption)) {
                DhcpOption option = new DhcpOption((int)dhcpCode, dhcpCurrentCodeOption);
                toBeAddedDhcpOptions.addOption(option);
                continue;
            }
            toBeAddedDhcpOptions.addOptionToRemove(dhcpCode);
        }
        return toBeAddedDhcpOptions;
    }
}

