/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.nuage.vsp.acs.client.api.NuageVspStatistics;
import net.nuage.vsp.acs.client.api.model.NuageVspPaging;
import net.nuage.vsp.acs.client.api.model.NuageVspUser;
import net.nuage.vsp.acs.client.api.model.Protocol;
import net.nuage.vsp.acs.client.api.model.VspHost;
import net.nuage.vsp.acs.client.common.FilterProcessor;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.NuageVspConstants;
import net.nuage.vsp.acs.client.common.RequestType;
import net.nuage.vsp.acs.client.common.model.Acl;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspError;
import net.nuage.vsp.acs.client.common.model.NuageVspFilter;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.model.Pair;
import net.nuage.vsp.acs.client.common.model.gson.CodedEnumTypeAdapter;
import net.nuage.vsp.acs.client.common.model.gson.IntCodedEnumTypeAdapter;
import net.nuage.vsp.acs.client.common.model.gson.NuageVspObjectTypeAdapter;
import net.nuage.vsp.acs.client.common.model.gson.ProtocolTypeAdapter;
import net.nuage.vsp.acs.client.common.ssl.TLSSocketFactory;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.exception.NuageJsonParsingException;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspAuthenticationException;
import net.nuage.vsp.acs.client.exception.NuageVspConnectivityException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import net.nuage.vsp.acs.client.exception.UnsupportedNuageEntityException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.codehaus.jackson.map.ObjectMapper;

public class NuageVspRestApi {
    private static final Logger s_logger = new Logger(NuageVspRestApi.class);
    private static final long DELAY_FACTOR = 2L;
    private volatile Optional<String> apiKey = Optional.absent();
    private NuageVspStatistics statistics;
    protected VspHost vspHost;
    private PoolingClientConnectionManager s_httpClientManager = null;
    private HttpClient client;
    private ObjectMapper mapper = new ObjectMapper();

    public NuageVspRestApi(VspHost vspHost, NuageVspStatistics nuageVspStatistics) {
        this.vspHost = vspHost;
        this.statistics = nuageVspStatistics;
    }

    public NuageVspObject createResource(NuageVspObject entity, NuageVspUser proxyUser) throws NuageVspApiException {
        String json = this.executeRestApiWithRetry(RequestType.CREATE, entity.getEntityType(), null, null, entity, true, null, null, proxyUser);
        return this.getFirstJsonEntity(entity.getEntityType(), json);
    }

    public NuageVspObject createResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspObject childEntity, Boolean checkWarning, NuageVspUser proxyUser, NuageVspConstants.ErrorCode ... retryNuageErrorCodes) throws NuageVspApiException {
        EnumSet<NuageVspConstants.ErrorCode> retryNuageErrorCodesSet = null;
        if (retryNuageErrorCodes.length != 0) {
            retryNuageErrorCodesSet = EnumSet.copyOf(Arrays.asList(retryNuageErrorCodes));
        }
        String json = this.executeRestApiWithRetry(RequestType.CREATE, parentEntityType, parentEntityId, childEntity.getEntityType(), childEntity, checkWarning, retryNuageErrorCodesSet, null, proxyUser);
        return this.getFirstJsonEntity(childEntity.getEntityType(), json);
    }

    public NuageVspObject createResource(NuageVspObject entity) throws NuageVspApiException {
        return this.createResource(entity, null);
    }

    public NuageVspObject createResource(NuageVspObject entity, String proxyUserUuid, String proxyUserDomainUuid) throws NuageVspApiException {
        return this.createResource(entity, new NuageVspUser(proxyUserDomainUuid, proxyUserUuid));
    }

    public NuageVspObject createResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspObject childEntity) throws NuageVspApiException {
        return this.createResource(parentEntityType, parentEntityId, childEntity, null, null);
    }

    public NuageVspObject createResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspObject childEntity, String proxyUserUuid, String proxyUserDomainUuid) throws NuageVspApiException {
        return this.createResource(parentEntityType, parentEntityId, childEntity, null, new NuageVspUser(proxyUserDomainUuid, proxyUserUuid), new NuageVspConstants.ErrorCode[0]);
    }

    public NuageVspObject createResource(NuageVspObject parent, NuageVspObject child, NuageVspConstants.ErrorCode ... retryNuageErrorCodes) throws NuageVspApiException {
        return this.createResource(parent.getEntityType(), parent.getId(), child, null, null, retryNuageErrorCodes);
    }

    public String updateResource(NuageVspObject nuageVspObject) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.MODIFY, nuageVspObject.getEntityType(), nuageVspObject.getId(), null, nuageVspObject, false, null, null, null);
    }

    public String updateResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspEntity childEntityType, Object childEntity) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.MODIFYRELATED, parentEntityType, parentEntityId, childEntityType, childEntity, false, null, null, null);
    }

    public String deleteResource(NuageVspEntity entityType, String entityId) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.DELETE, entityType, entityId, null, null, null, null, null, null);
    }

    public String deleteResource(NuageVspObject nuageVspObject) throws NuageVspApiException {
        return this.deleteResource(nuageVspObject.getEntityType(), nuageVspObject.getId());
    }

    public boolean deleteQuietly(NuageVspObject entityToBeCleaned) {
        try {
            this.deleteResource(entityToBeCleaned);
            s_logger.debug("Successfully cleaned stale VSP entity %s with ID %s", new Object[]{entityToBeCleaned.getEntityType(), entityToBeCleaned.getId()});
            return true;
        }
        catch (NuageVspApiException e) {
            s_logger.warn("Failed to clean %s with ID %s from NuageVsp. Please contact Nuage Vsp csproot to clean stale objects", new Object[]{entityToBeCleaned.getEntityType(), entityToBeCleaned.getId()});
            return false;
        }
    }

    public boolean deleteQuietly(NuageVspEntity entityToBeCleaned, String entityIDToBeCleaned) {
        try {
            this.deleteResource(entityToBeCleaned, entityIDToBeCleaned);
            s_logger.debug("Successfully cleaned stale VSP entity %s with ID %s", new Object[]{entityToBeCleaned, entityIDToBeCleaned});
            return true;
        }
        catch (NuageVspApiException e) {
            s_logger.warn("Failed to clean %s with ID %s from NuageVsp. Please contact Nuage Vsp csproot to clean stale objects", new Object[]{entityToBeCleaned, entityIDToBeCleaned});
            return false;
        }
    }

    public String getResources(NuageVspEntity nuageEntityType, NuageVspPaging paging) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GETALL, nuageEntityType, null, null, null, true, null, paging, null);
    }

    public String getChildResources(NuageVspEntity parentEntityType, String parentEntityId, NuageVspEntity nuageChildEntityType, NuageVspPaging paging) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GETRELATED, parentEntityType, parentEntityId, nuageChildEntityType, null, true, null, paging, null);
    }

    public String getResource(NuageVspEntity nuageEntityType, String entityId, Boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GET, nuageEntityType, entityId, null, null, checkWarning, null, null, null);
    }

    public String resourceExists(NuageVspEntity nuageEntityType, String entityId, Boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.HEAD, nuageEntityType, entityId, null, null, checkWarning, null, null, null);
    }

    public NuageVspObject getResource(NuageVspEntity nuageEntityType, String entityId) throws NuageVspApiException {
        String json = this.getResource(nuageEntityType, entityId, true);
        return this.getOnlyJsonEntity(nuageEntityType, json);
    }

    public String getResources(NuageVspEntity nuageEntityType, NuageVspFilter filter) throws NuageVspApiException {
        return this.getResources(nuageEntityType, NuageVspPaging.paging().filter(filter));
    }

    public String getResources(NuageVspEntity nuageEntityType) throws NuageVspApiException {
        return this.getResources(nuageEntityType, (NuageVspPaging)null);
    }

    public String getResources(NuageVspObject nuageVspObject, NuageVspEntity nuageChildEntityType) throws NuageVspApiException {
        return this.getChildResources(nuageVspObject.getEntityType(), nuageVspObject.getId(), nuageChildEntityType, null);
    }

    public String getResources(NuageVspObject nuageVspObject, NuageVspEntity nuageChildEntityType, NuageVspFilter filter) throws NuageVspApiException {
        return this.getChildResources(nuageVspObject.getEntityType(), nuageVspObject.getId(), nuageChildEntityType, NuageVspPaging.paging().filter(filter));
    }

    public String getResources(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType) throws NuageVspApiException {
        return this.getChildResources(nuageEntityType, entityId, nuageChildEntityType, null);
    }

    public String getResources(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, NuageVspFilter filter) throws NuageVspApiException {
        return this.getChildResources(nuageEntityType, entityId, nuageChildEntityType, NuageVspPaging.paging().filter(filter));
    }

    public String getResources(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, NuageVspAttribute filterAttribute, Object filterValue) throws NuageVspApiException {
        return this.getChildResources(nuageEntityType, entityId, nuageChildEntityType, NuageVspPaging.paging().filter(NuageVspRestApi.createFilter(filterAttribute, filterValue)));
    }

    private Set<String> getLinkedEntities(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType) throws NuageVspApiException {
        String currentRelatedEntitiesJson = this.getResources(nuageEntityType, entityId, nuageChildEntityType);
        List<NuageVspObject> currentRelatedEntities = this.parseJsonString(nuageChildEntityType, currentRelatedEntitiesJson);
        TreeSet<String> currentChildEntityIds = new TreeSet<String>();
        for (NuageVspObject currentRelatedEntity : currentRelatedEntities) {
            currentChildEntityIds.add(currentRelatedEntity.getId());
        }
        return currentChildEntityIds;
    }

    protected boolean saveLinkedEntities(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Set<String> oldNuageChildEntityIds, Set<String> newNuageChildEntityIds) throws NuageVspApiException {
        boolean isModified;
        boolean bl = isModified = !oldNuageChildEntityIds.equals(newNuageChildEntityIds);
        if (isModified) {
            this.updateResource(nuageEntityType, entityId, nuageChildEntityType, newNuageChildEntityIds);
        }
        return isModified;
    }

    public void linkRelatedEntity(NuageVspObject nuageVspObject, NuageVspEntity nuageChildEntityType, String nuageChildEntityId) throws NuageVspException {
        this.linkRelatedEntity(nuageVspObject.getEntityType(), nuageVspObject.getId(), nuageChildEntityType, nuageChildEntityId);
    }

    public boolean linkRelatedEntity(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, String nuageChildEntityId) throws NuageVspException {
        Set<String> currentChildEntityIds = this.getLinkedEntities(nuageEntityType, entityId, nuageChildEntityType);
        TreeSet<String> nuageChildEntityIds = new TreeSet<String>(currentChildEntityIds);
        nuageChildEntityIds.add(nuageChildEntityId);
        return this.saveLinkedEntities(nuageEntityType, entityId, nuageChildEntityType, currentChildEntityIds, nuageChildEntityIds);
    }

    public boolean unlinkRelatedEntity(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, String nuageChildEntityId) throws NuageVspException {
        Set<String> currentChildEntityIds = this.getLinkedEntities(nuageEntityType, entityId, nuageChildEntityType);
        TreeSet<String> nuageChildEntityIds = new TreeSet<String>(currentChildEntityIds);
        nuageChildEntityIds.remove(nuageChildEntityId);
        return this.saveLinkedEntities(nuageEntityType, entityId, nuageChildEntityType, currentChildEntityIds, nuageChildEntityIds);
    }

    public boolean setRelatedEntities(NuageVspObject nuageVspObject, NuageVspEntity nuageChildEntityType, Set<String> nuageChildEntityIds) throws NuageVspException {
        return this.setRelatedEntities(nuageVspObject.getEntityType(), nuageVspObject.getId(), nuageChildEntityType, nuageChildEntityIds);
    }

    public boolean setRelatedEntities(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Set<String> nuageChildEntityIds) throws NuageVspException {
        Set<String> currentChildEntityIds = this.getLinkedEntities(nuageEntityType, entityId, nuageChildEntityType);
        return this.saveLinkedEntities(nuageEntityType, entityId, nuageChildEntityType, currentChildEntityIds, nuageChildEntityIds);
    }

    protected static NuageVspFilter createFilter(NuageVspAttribute filterAttr, Object filterAttrValue) {
        NuageVspFilter.BinaryOperatorBuilder field = NuageVspFilter.where().field(filterAttr);
        if (filterAttr == NuageVspAttribute.EXTERNAL_ID && filterAttrValue != null) {
            return field.startsWith((String)filterAttrValue);
        }
        return field.eq(filterAttrValue);
    }

    public NuageVspObject getOnlyJsonEntity(NuageVspEntity entityType, String jsonString) throws NuageVspApiException {
        return (NuageVspObject)Iterables.getOnlyElement(this.parseJsonString(entityType, jsonString));
    }

    public NuageVspObject getFirstJsonEntity(NuageVspEntity entityType, String jsonString) throws NuageVspApiException {
        return (NuageVspObject)Iterables.getFirst(this.parseJsonString(entityType, jsonString), null);
    }

    public NuageVspObject getEntityByExternalId(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, String externalId) throws NuageVspApiException {
        if (externalId == null) {
            return null;
        }
        NuageVspFilter filter = NuageVspRestApi.createFilter(NuageVspAttribute.EXTERNAL_ID, externalId);
        String jsonString = childEntityType == null && entityId == null ? this.getResources(entityType, filter) : this.getResources(entityType, entityId, childEntityType, filter);
        NuageVspEntity entity = (NuageVspEntity)((Object)MoreObjects.firstNonNull((Object)((Object)childEntityType), (Object)((Object)entityType)));
        return this.getFirstJsonEntity(entity, jsonString);
    }

    public String getEntityId(NuageVspEntity entityType, String jsonString) throws NuageVspApiException {
        String id = "";
        if (StringUtils.isNotBlank((String)jsonString)) {
            id = this.getOnlyJsonEntity(entityType, jsonString).getId();
        }
        return id;
    }

    private String executeRestApiWithRetry(RequestType type, NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Object entityDetails, Boolean checkWarning, Set<NuageVspConstants.ErrorCode> retryNuageErrorCodes, NuageVspPaging paging, NuageVspUser proxyUser) throws NuageVspApiException {
        int attempt = 1;
        long sleepTime = this.vspHost.getRetryInterval();
        NuageVspApiException exception = null;
        while (true) {
            Pair<String, String> urlAndResponse = Pair.of("", "");
            try {
                urlAndResponse = this.executeNuageApi(nuageEntityType, entityId, nuageChildEntityType, entityDetails, type, checkWarning, paging, proxyUser);
                if (attempt > 1) {
                    s_logger.trace("After %s attempt, exception %s was handled and method %s was successfully executed ", --attempt, exception.getMessage(), "executeHttpRequestWithRetry");
                }
                return urlAndResponse.getRight();
            }
            catch (NuageVspApiException e) {
                exception = e;
                if (attempt < true) continue;
                if (attempt <= this.vspHost.getNoofRetry() && !this.handleException(attempt, sleepTime, e, "executeHttpRequestWithRetry", urlAndResponse.getLeft(), retryNuageErrorCodes)) {
                    throw e;
                }
                ++attempt;
                sleepTime *= 2L;
                if (attempt <= this.vspHost.getNoofRetry() + 1) continue;
                s_logger.error((Object)String.format("Failed to execute %s method even after %s attempts, due to exception %s ", "executeHttpRequestWithRetry", this.vspHost.getNoofRetry(), exception.getMessage()), new Object[0]);
                throw exception;
            }
            break;
        }
    }

    public Pair<String, String> executeNuageApi(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, Object entityDetails, RequestType type, boolean checkWarning, NuageVspPaging paging, NuageVspUser proxyUser, String restRelativePath) {
        return null;
    }

    public Pair<String, String> executeNuageApi(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, Object entityDetails, RequestType type, Boolean checkWarning, NuageVspPaging paging, NuageVspUser proxyUser) throws NuageVspApiException {
        this.statistics.reportVSDCall((NuageVspEntity)((Object)MoreObjects.firstNonNull((Object)((Object)childEntityType), (Object)((Object)entityType))), type);
        HttpPost httpMethod = null;
        HttpResponse response = null;
        String restUrl = this.getRestPath(entityType, entityId, childEntityType, type, checkWarning);
        try {
            FilterProcessor.processFilter(paging, this.vspHost.getNuageVspCmsId());
            URI uri = new URI(restUrl);
            switch (type) {
                case CREATE: {
                    httpMethod = new HttpPost(uri);
                    break;
                }
                case MODIFY: 
                case MODIFYRELATED: {
                    httpMethod = new HttpPut(uri);
                    break;
                }
                case DELETE: {
                    httpMethod = new HttpDelete(uri);
                    break;
                }
                case HEAD: {
                    httpMethod = new HttpHead(uri);
                }
                default: {
                    httpMethod = new HttpGet(uri);
                }
            }
            if (!this.apiKey.isPresent() && entityType != NuageVspEntity.ME) {
                this.login();
            }
            this.setHttpHeaders((HttpRequestBase)httpMethod, entityType, paging, proxyUser);
            if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
                String jsonString = entityDetails instanceof List || entityDetails instanceof Set || entityDetails instanceof Map || entityDetails instanceof NuageVspObject ? this.getJsonString(entityDetails) : "";
                httpMethod.setHeader("Content-Type", "application/json");
                StringEntity entity = new StringEntity(jsonString);
                ((HttpEntityEnclosingRequestBase)httpMethod).setEntity((HttpEntity)entity);
            }
            long time = System.currentTimeMillis();
            if (this.client == null) {
                this.createHttpClient();
                s_logger.debug("Http client is not initialized. So, it is re-initialized to execute https %s with url %s.", httpMethod, null);
            }
            response = this.client.execute((HttpUriRequest)httpMethod);
            s_logger.trace("Total time taken to execute HTTPS method %s %s - %d ms.", new Object[]{type, null, System.currentTimeMillis() - time});
            String entity = this.parseHttpResponse(response, childEntityType != null ? childEntityType : entityType, type);
            Pair<String, String> pair = Pair.of(restUrl, entity);
            return pair;
        }
        catch (NuageVspApiException e) {
            throw e;
        }
        catch (SSLPeerUnverifiedException e) {
            this.client = null;
            this.createHttpClient();
            s_logger.debug("Reinitialized HTTP client because of new SSL certificate", new Object[0]);
            throw new NuageVspApiException(500, null, "Throwing exception to trigger retry with reinitialized HTTP client", e);
        }
        catch (SSLException | ClientProtocolException e) {
            throw new NuageVspConnectivityException("Failed to setup SSL", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NuageJsonParsingException("Unsupported Encoding", e);
        }
        catch (IOException ioe) {
            s_logger.error((Object)("Error while executing HTTPS method " + (Object)((Object)type) + " " + null), ioe);
            throw new NuageVspConnectivityException("Error while executing HTTPS method " + (Object)((Object)type) + " " + null, ioe);
        }
        catch (URISyntaxException urise) {
            s_logger.error((Object)("Error while building URI " + null), urise);
            throw new NuageVspApiException("Error while building URI " + null, urise);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected void createHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)120000);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        if (this.s_httpClientManager == null) {
            this.s_httpClientManager = new PoolingClientConnectionManager(TLSSocketFactory.createSchemeRegistry());
            this.s_httpClientManager.setDefaultMaxPerRoute(200);
            this.s_httpClientManager.setMaxTotal(200);
        }
        this.client = new DefaultHttpClient((ClientConnectionManager)this.s_httpClientManager, (HttpParams)params);
    }

    private void setHttpHeaders(HttpRequestBase httpMethod, NuageVspEntity entityType, NuageVspPaging paging, NuageVspUser proxyUser) {
        NuageVspUser cmsUserInfo = this.vspHost.getCmsUserInfo();
        StringBuilder authStr = new StringBuilder().append(cmsUserInfo.getUserName()).append(":");
        if (entityType == NuageVspEntity.ME) {
            authStr.append(cmsUserInfo.getPassword());
        } else {
            authStr.append((String)this.apiKey.or((Object)""));
        }
        String encoding = Base64.encodeBase64String((byte[])authStr.toString().getBytes());
        httpMethod.setHeader("Authorization", "Basic " + encoding);
        httpMethod.setHeader("X-Nuage-Organization", cmsUserInfo.getEnterpriseName());
        if (httpMethod.getMethod().equals("") && proxyUser != null) {
            String proxyUserHeader = proxyUser.getUserName().replace("-", "") + "@" + proxyUser.getEnterpriseName();
            httpMethod.setHeader("X-Nuage-ProxyUser", proxyUserHeader);
        }
        if (paging != null) {
            if (paging.hasFilter()) {
                NuageVspFilter filter = paging.getFilter();
                httpMethod.setHeader("X-Nuage-Filter", filter.getFilterString(this.vspHost.getApiVersion()));
                if (filter.hasOrderBy()) {
                    httpMethod.setHeader("X-Nuage-OrderBy", filter.getOrderByString());
                }
            }
            if (paging.hasPage()) {
                httpMethod.setHeader("X-Nuage-Page", String.valueOf(paging.getPage()));
            }
            if (paging.hasPageSize()) {
                httpMethod.setHeader("X-Nuage-PageSize", String.valueOf(paging.getPageSize()));
            }
        }
    }

    private String getRestPath(NuageVspEntity entity) {
        StringBuilder url = new StringBuilder(this.vspHost.getRestRelativePath());
        url.append("/").append(entity.getEntityType());
        return url.toString();
    }

    private String getRestPath(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, RequestType type, Boolean checkWarning) {
        assert (childEntityType != null == type.requiresIdAndChildEntityType());
        StringBuilder url = new StringBuilder();
        if (entityType != NuageVspEntity.VERSION) {
            url.append(this.vspHost.getRestRelativePath());
        } else {
            url.append(this.vspHost.getRootPath());
        }
        url.append("/").append(entityType.getEntityType());
        if (childEntityType != null) {
            url.append("/").append(entityId).append("/").append(childEntityType.getEntityType());
        } else if (type.requiresId() && entityType != NuageVspEntity.ME) {
            url.append("/").append(entityId);
        }
        if (checkWarning == null) {
            checkWarning = type.isIdempotent();
        }
        if (!checkWarning.booleanValue()) {
            url.append("?responseChoice=1");
        }
        return url.toString();
    }

    public void login() throws NuageVspApiException {
        try {
            String groupJson;
            NuageVspObject cmsGroup;
            Pair<String, String> result = this.executeNuageApi(NuageVspEntity.ME, null, null, null, RequestType.GET, null, null, null);
            String meJson = result.getRight();
            NuageVspObject me = (NuageVspObject)Iterables.getFirst(this.parseJsonString(NuageVspEntity.ME, meJson), null);
            if (me == null) {
                this.apiKey = Optional.absent();
                return;
            }
            this.apiKey = Optional.fromNullable(me.get(NuageVspAttribute.APIKEY));
            String systemEnterpriseId = (String)me.get(NuageVspAttribute.ENTERPRISE_ID);
            if (StringUtils.isNotBlank((String)systemEnterpriseId) && (cmsGroup = (NuageVspObject)Iterables.getOnlyElement(this.parseJsonString(NuageVspEntity.GROUP, groupJson = this.getResources(NuageVspEntity.ENTERPRISE, systemEnterpriseId, NuageVspEntity.GROUP, NuageVspFilter.where(NuageVspAttribute.GROUP_ROLE).eq("CMS"))), null)) != null) {
                String cmsUsersJson = this.getResources(NuageVspEntity.GROUP, (String)cmsGroup.get(NuageVspAttribute.ID), NuageVspEntity.USER);
                List<NuageVspObject> cmsUsers = this.parseJsonString(NuageVspEntity.USER, cmsUsersJson);
                for (NuageVspObject cmsUser : cmsUsers) {
                    String cmsUsername = (String)cmsUser.get(NuageVspAttribute.USER_USERNAME);
                    if (!cmsUsername.equals(this.vspHost.getCmsUserLogin())) continue;
                    return;
                }
            }
        }
        catch (NuageVspAuthenticationException e) {
            s_logger.warn("Failed to authenticate on Nuage VSP device. Provided credentials are invalid.", e);
            throw e;
        }
        catch (NuageVspException e) {
            throw NuageVspRestApi.handleException("Failed to check if the user is part of the CMS group", e, new Object[0]);
        }
        s_logger.error((Object)("User '" + this.vspHost.getCmsUserLogin() + "' is not part of the CMS group!"), new Object[0]);
        throw new NuageVspApiException("User '" + this.vspHost.getCmsUserLogin() + "' is not part of the CMS group!");
    }

    public String getJsonString(Object entityDetails) throws NuageJsonParsingException {
        try {
            return this.getGsonInstance(null).toJson(entityDetails);
        }
        catch (JsonSyntaxException jsonException) {
            s_logger.error((Object)"Error while retrieving JSON from complex data", jsonException);
            throw new NuageJsonParsingException("Error while retrieving JSON from complex data", jsonException);
        }
    }

    private String parseHttpResponse(HttpResponse httpResponse, NuageVspEntity entityType, RequestType type) throws NuageVspApiException {
        String jsonResult = NuageVspRestApi.getJsonFromResponse(httpResponse);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        String errorMessage = "NUAGE HTTP REQUEST %s: HTTP Response code: %d: Response : %s";
        if (statusCode >= 402 && statusCode <= 599) {
            NuageVspError error;
            if (httpResponse.getFirstHeader("Content-Type").getValue().equals("application/json")) {
                error = this.parseJsonError(jsonResult);
                if (statusCode == 404) {
                    error.setInternalErrorCode(NuageVspConstants.ErrorCode.RESOURCE_NOT_FOUND);
                }
            } else {
                error = new NuageVspError(NuageVspConstants.ErrorCode.RESOURCE_NOT_FOUND, null, null);
            }
            NuageVspConstants.ErrorCode nuageErrorCode = error.getInternalErrorCode();
            String nuageErrorDetails = error.getStackTrace();
            if (nuageErrorCode != null || nuageErrorDetails != null) {
                if (nuageErrorCode == NuageVspConstants.ErrorCode.DUPLICATE_ACL_PRIORITY) {
                    s_logger.warn(errorMessage, "FAILED", statusCode, jsonResult);
                } else {
                    if (type == RequestType.DELETE && nuageErrorCode == NuageVspConstants.ErrorCode.RESOURCE_NOT_FOUND) {
                        s_logger.info(errorMessage, "FAILED", statusCode, jsonResult);
                        return jsonResult;
                    }
                    if (nuageErrorCode != NuageVspConstants.ErrorCode.NO_CHANGE_IN_ENTITY) {
                        s_logger.error((Object)errorMessage, "FAILED", statusCode, jsonResult);
                    }
                }
                throw new NuageVspApiException(statusCode, errorMessage, nuageErrorCode, nuageErrorDetails, entityType, type);
            }
        } else {
            if (statusCode == 400) {
                s_logger.trace(errorMessage, statusCode, jsonResult);
                throw new NuageVspApiException(httpResponse.getStatusLine().getStatusCode(), errorMessage, null, "The request sent by the client was syntactically incorrect", entityType, type);
            }
            if (statusCode == 401) {
                s_logger.trace(errorMessage, new Object[0]);
                throw new NuageVspAuthenticationException(errorMessage);
            }
            if (statusCode >= 200 && statusCode <= 299) {
                s_logger.trace(errorMessage, "RESULT", statusCode, jsonResult);
            }
        }
        return jsonResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJsonFromResponse(HttpResponse httpResponse) throws NuageJsonParsingException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) return "";
        try (InputStream inputStream = entity.getContent();){
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (IOException ioe) {
            throw new NuageJsonParsingException(null, ioe);
        }
    }

    private NuageVspError parseJsonError(String jsonResult) throws NuageJsonParsingException {
        NuageVspError error = (NuageVspError)new GsonBuilder().registerTypeAdapter(NuageVspConstants.ErrorCode.class, new IntCodedEnumTypeAdapter()).create().fromJson(jsonResult, NuageVspError.class);
        return error;
    }

    public List<NuageVspObject> parseJsonString(NuageVspEntity nuageEntity, String jsonResult) throws NuageJsonParsingException, UnsupportedNuageEntityException {
        if (StringUtils.isBlank((String)jsonResult)) {
            return new LinkedList<NuageVspObject>();
        }
        return (List)this.parseJsonString(nuageEntity, jsonResult, NuageVspObjectTypeAdapter.LIST_TYPE);
    }

    public <T> T parseJsonString(NuageVspEntity nuageEntity, String jsonResult, Type type) throws NuageJsonParsingException, UnsupportedNuageEntityException {
        NuageVspApiVersion apiVersion = this.vspHost.getApiVersion();
        Collection<String> attributeNames = nuageEntity.getAttributeNameList(apiVersion);
        if (attributeNames == null) {
            throw new UnsupportedNuageEntityException(nuageEntity.getEntityType() + " is not defined in NuageEntity enum. Please add it if it needs to be supported");
        }
        Gson gson = this.getGsonInstance(nuageEntity);
        try {
            return (T)gson.fromJson(jsonResult, type);
        }
        catch (JsonSyntaxException ioe) {
            throw new NuageJsonParsingException("Failed to parse the Json response from VSP REST API. Json string is " + jsonResult, ioe);
        }
    }

    private Gson getGsonInstance(NuageVspEntity nuageEntity) {
        return new GsonBuilder().registerTypeAdapter(NuageVspObject.class, (Object)new NuageVspObjectTypeAdapter(nuageEntity, this.vspHost.getApiVersion(), this.vspHost.getNuageVspCmsId())).registerTypeAdapter(Protocol.class, (Object)new ProtocolTypeAdapter()).registerTypeAdapter(Acl.AclEtherType.class, new CodedEnumTypeAdapter()).serializeNulls().create();
    }

    protected NuageVspObject createNuageVspObject(NuageVspEntity entity) {
        return new NuageVspObject(this.vspHost.getApiVersion(), entity);
    }

    protected NuageVspObject createNuageVspObject(NuageVspEntity entity, String entityId) {
        return new NuageVspObject(this.vspHost.getApiVersion(), entity, entityId);
    }

    protected static NuageVspApiException handleException(String message, NuageVspException cause, Object ... args) {
        if (cause instanceof NuageVspApiException) {
            return (NuageVspApiException)cause;
        }
        if (args.length > 0) {
            message = String.format(message, args);
        }
        s_logger.error((Object)message, cause);
        return new NuageVspApiException(message, cause);
    }

    private boolean handleException(int attempt, long sleepTime, Exception e, String methodName, String url, Set<NuageVspConstants.ErrorCode> retryNuageErrorCodes) throws NuageVspApiException {
        NuageVspApiException exception;
        boolean retry = false;
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        Throwable throwable = rootCause = rootCause == null ? e : rootCause;
        if (rootCause instanceof NuageVspAuthenticationException) {
            s_logger.trace(String.format("Authentication failed so failed to execute Nuage VSP API %s", url), new Object[0]);
            NuageVspRestApi.printRetryMessage(attempt, sleepTime, methodName, url, rootCause);
            try {
                retry = true;
                Thread.sleep(sleepTime);
                this.login();
            }
            catch (InterruptedException e1) {
                s_logger.warn("Retry sleeping got interrupted", new Object[0]);
                throw new NuageVspApiException("Retry sleeping got interrupted", e);
            }
            catch (NuageVspException nve) {
                s_logger.error((Object)"Failed to login to VSD", nve);
                throw new NuageVspApiException("Failed to login to VSD", nve);
            }
        } else if (rootCause instanceof SSLException || e instanceof SSLException) {
            NuageVspRestApi.printRetryMessage(attempt, sleepTime, methodName, url, rootCause);
            retry = NuageVspRestApi.setRetryFlag(sleepTime);
        } else if (rootCause instanceof NuageVspApiException && ((exception = (NuageVspApiException)rootCause).getHttpErrorCode() == 500 || retryNuageErrorCodes != null && retryNuageErrorCodes.contains(exception.getNuageErrorCode()))) {
            NuageVspRestApi.printRetryMessage(attempt, sleepTime, methodName, url, rootCause);
            retry = NuageVspRestApi.setRetryFlag(sleepTime);
        }
        return retry;
    }

    private static void printRetryMessage(int attempt, long sleepTime, String methodName, String url, Throwable rootCause) {
        s_logger.trace("Failed to execute Nuage VSP API %s : %s", url, rootCause.getMessage());
        s_logger.trace("Attempt %s to re-execute the method %s", attempt, methodName);
        s_logger.trace("Waiting %s millis before re-executing the method %s", sleepTime, methodName);
    }

    private static boolean setRetryFlag(long sleepTime) throws NuageVspApiException {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            s_logger.warn("Retry sleeping got interrupted", new Object[0]);
            throw new NuageVspApiException("Retry sleeping got interrupted", e);
        }
        return true;
    }

    public boolean isExistingResource(NuageVspEntity entity, String entityId) {
        try {
            return this.resourceExists(entity, entityId, true) != null;
        }
        catch (NuageVspException e) {
            return false;
        }
    }
}

