/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.nuage.vsp.acs.client.api.NuageVspStatistics;
import net.nuage.vsp.acs.client.common.RequestType;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;

public class NuageVspStatisticsImpl
implements NuageVspStatistics {
    private AtomicLong globalCount = new AtomicLong();
    private Table<NuageVspEntity, RequestType, AtomicLong> entityCount = HashBasedTable.create((int)NuageVspEntity.values().length, (int)RequestType.values().length);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportVSDCall(NuageVspEntity entity, RequestType requestType) {
        Table<NuageVspEntity, RequestType, AtomicLong> table = this.entityCount;
        synchronized (table) {
            AtomicLong atomicLong = (AtomicLong)this.entityCount.get((Object)entity, (Object)requestType);
            if (atomicLong == null) {
                atomicLong = new AtomicLong(0L);
                this.entityCount.put((Object)entity, (Object)requestType, (Object)atomicLong);
            }
            atomicLong.incrementAndGet();
        }
        this.globalCount.incrementAndGet();
    }

    @Override
    public Map<NuageVspEntity, Map<RequestType, AtomicLong>> getVsdCountReport() {
        return this.entityCount.rowMap();
    }

    @Override
    public long getVsdCount(NuageVspEntity entity, RequestType type) {
        AtomicLong atomicLong = (AtomicLong)this.entityCount.get((Object)entity, (Object)type);
        return atomicLong != null ? atomicLong.get() : 0L;
    }

    @Override
    public long getVsdCount(NuageVspEntity entity) {
        long count = this.entityCount.row((Object)entity).values().stream().mapToLong(AtomicLong::get).sum();
        return count;
    }

    @Override
    public long getVsdCount(RequestType type) {
        long count = this.entityCount.column((Object)type).values().stream().mapToLong(AtomicLong::get).sum();
        return count;
    }

    @Override
    public long getVsdCount() {
        return this.globalCount.get();
    }
}

