/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.model;

import java.util.Objects;
import net.nuage.vsp.acs.client.api.model.VspBuilder;
import net.nuage.vsp.acs.client.api.model.VspNic;
import net.nuage.vsp.acs.client.api.model.VspObject;

public class VspStaticNat
extends VspObject {
    private final State state;
    private final String ipUuid;
    private final String ipAddress;
    private final VspNic vspNic;
    private final Boolean revoke;
    private final Boolean oneToOneNat;
    private final String vlanUuid;
    private final String vlanGateway;
    private final String vlanNetmask;
    private final boolean vlanUnderlay;

    private VspStaticNat(State state, String ipUuid, String ipAddress, VspNic vspNic, Boolean revoke, Boolean oneToOneNat, String vlanUuid, String vlanGateway, String vlanNetmask, boolean vlanUnderlay) {
        this.state = state;
        this.ipUuid = ipUuid;
        this.ipAddress = ipAddress;
        this.vspNic = vspNic;
        this.revoke = revoke;
        this.oneToOneNat = oneToOneNat;
        this.vlanUuid = vlanUuid;
        this.vlanGateway = vlanGateway;
        this.vlanNetmask = vlanNetmask;
        this.vlanUnderlay = vlanUnderlay;
    }

    public State getState() {
        return this.state;
    }

    public String getIpUuid() {
        return this.ipUuid;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public VspNic getVspNic() {
        return this.vspNic;
    }

    public Boolean getRevoke() {
        return this.revoke;
    }

    public Boolean getOneToOneNat() {
        return this.oneToOneNat;
    }

    public String getVlanUuid() {
        return this.vlanUuid;
    }

    public String getVlanGateway() {
        return this.vlanGateway;
    }

    public String getVlanNetmask() {
        return this.vlanNetmask;
    }

    public boolean isVlanUnderlay() {
        return this.vlanUnderlay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VspStaticNat)) {
            return false;
        }
        VspStaticNat that = (VspStaticNat)o;
        return Objects.equals(this.vlanUnderlay, that.vlanUnderlay) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.ipUuid, that.ipUuid) && Objects.equals(this.oneToOneNat, that.oneToOneNat) && Objects.equals(this.revoke, that.revoke) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.vlanGateway, that.vlanGateway) && Objects.equals(this.vlanNetmask, that.vlanNetmask) && Objects.equals(this.vlanUuid, that.vlanUuid) && Objects.equals(this.vspNic, that.vspNic);
    }

    public int hashCode() {
        int result = this.state != null ? this.state.hashCode() : 0;
        result = 31 * result + (this.ipUuid != null ? this.ipUuid.hashCode() : 0);
        result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
        result = 31 * result + (this.vspNic != null ? this.vspNic.hashCode() : 0);
        result = 31 * result + (this.revoke != null ? this.revoke.hashCode() : 0);
        result = 31 * result + (this.oneToOneNat != null ? this.oneToOneNat.hashCode() : 0);
        result = 31 * result + (this.vlanUuid != null ? this.vlanUuid.hashCode() : 0);
        result = 31 * result + (this.vlanGateway != null ? this.vlanGateway.hashCode() : 0);
        result = 31 * result + (this.vlanNetmask != null ? this.vlanNetmask.hashCode() : 0);
        result = 31 * result + (this.vlanUnderlay ? 1 : 0);
        return result;
    }

    public static class Builder
    extends VspBuilder<Builder, VspStaticNat> {
        private State state;
        private String ipUuid;
        private String ipAddress;
        private VspNic vspNic;
        private Boolean revoke;
        private Boolean oneToOneNat;
        private String vlanUuid;
        private String vlanGateway;
        private String vlanNetmask;
        private boolean vlanUnderlay;

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder ipUuid(String ipUuid) {
            this.ipUuid = ipUuid;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder nic(VspNic vspNic) {
            this.vspNic = vspNic;
            return this;
        }

        public Builder revoke(Boolean revoke) {
            this.revoke = revoke;
            return this;
        }

        public Builder oneToOneNat(Boolean oneToOneNat) {
            this.oneToOneNat = oneToOneNat;
            return this;
        }

        public Builder vlanUuid(String vlanUuid) {
            this.vlanUuid = vlanUuid;
            return this;
        }

        public Builder vlanGateway(String vlanGateway) {
            this.vlanGateway = vlanGateway;
            return this;
        }

        public Builder vlanNetmask(String vlanNetmask) {
            this.vlanNetmask = vlanNetmask;
            return this;
        }

        public Builder vlanUnderlay(boolean vlanUnderlay) {
            this.vlanUnderlay = vlanUnderlay;
            return this;
        }

        @Override
        public VspStaticNat build() {
            return new VspStaticNat(this.state, this.ipUuid, this.ipAddress, this.vspNic, this.revoke, this.oneToOneNat, this.vlanUuid, this.vlanGateway, this.vlanNetmask, this.vlanUnderlay);
        }

        @Override
        public Builder fromObject(VspStaticNat obj) {
            return new Builder().state(obj.getState()).ipUuid(obj.getIpUuid()).ipAddress(obj.getIpAddress()).nic(obj.getVspNic()).revoke(obj.getRevoke()).oneToOneNat(obj.getOneToOneNat()).vlanUuid(obj.getVlanUuid()).vlanGateway(obj.getVlanGateway()).vlanNetmask(obj.getVlanNetmask()).vlanUnderlay(obj.isVlanUnderlay());
        }
    }

    public static enum State {
        Allocating,
        Allocated,
        Releasing,
        Free;

    }
}

