/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.model;

import net.nuage.vsp.acs.client.api.model.VspBuilder;
import net.nuage.vsp.acs.client.api.model.VspObject;

public class VspVm
extends VspObject {
    private final State state;
    private final String uuid;
    private final String name;
    private final Boolean domainRouter;
    private final String domainRouterIp;

    private VspVm(State state, String uuid, String name, Boolean domainRouter, String domainRouterIp) {
        this.state = state;
        this.uuid = uuid;
        this.name = name;
        this.domainRouter = domainRouter;
        this.domainRouterIp = domainRouterIp;
    }

    public State getState() {
        return this.state;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getDomainRouter() {
        return this.domainRouter;
    }

    public String getDomainRouterIp() {
        return this.domainRouterIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VspVm)) {
            return false;
        }
        VspVm vspVm = (VspVm)o;
        if (this.domainRouter != null ? !this.domainRouter.equals(vspVm.domainRouter) : vspVm.domainRouter != null) {
            return false;
        }
        if (this.domainRouterIp != null ? !this.domainRouterIp.equals(vspVm.domainRouterIp) : vspVm.domainRouterIp != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(vspVm.name) : vspVm.name != null) {
            return false;
        }
        if (this.state != vspVm.state) {
            return false;
        }
        return !(this.uuid != null ? !this.uuid.equals(vspVm.uuid) : vspVm.uuid != null);
    }

    public int hashCode() {
        int result = this.state != null ? this.state.hashCode() : 0;
        result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.domainRouter != null ? this.domainRouter.hashCode() : 0);
        result = 31 * result + (this.domainRouterIp != null ? this.domainRouterIp.hashCode() : 0);
        return result;
    }

    public static class Builder
    extends VspBuilder<Builder, VspVm> {
        private State state;
        private String uuid;
        private String name;
        private Boolean domainRouter;
        private String domainRouterIp;

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder domainRouter(Boolean domainRouter) {
            this.domainRouter = domainRouter;
            return this;
        }

        public Builder domainRouterIp(String domainRouterIp) {
            this.domainRouterIp = domainRouterIp;
            return this;
        }

        @Override
        public VspVm build() {
            return new VspVm(this.state, this.uuid, this.name, this.domainRouter, this.domainRouterIp);
        }

        @Override
        public Builder fromObject(VspVm obj) {
            return new Builder().state(obj.getState()).uuid(obj.getUuid()).name(obj.getName()).domainRouter(obj.getDomainRouter()).domainRouterIp(obj.getDomainRouterIp());
        }
    }

    public static enum State {
        Starting,
        Running,
        Stopping,
        Stopped,
        Destroyed,
        Expunging,
        Migrating,
        Error,
        Unknown,
        Shutdowned;

    }
}

