/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.nuage.vsp.acs.client.common.model.IntCodedEnum;

public interface NuageVspConstants {
    public static final String CMS_USER_ENTEPRISE_NAME = "CSP";
    public static final int FLOATING_IP_QUOTA = 249999;
    public static final String DEFAULT_FWD_CLASS = "H";
    public static final String STAR = "*";
    public static final String USER_FIRST_NAME = "FN";
    public static final String USER_LAST_NAME = "LN";
    public static final String USER_EMAIL = "defaultemail@email.com";
    public static final String USER_PASSWORD = "default";
    public static final String ZONE_NAME = "zone";
    public static final String VSP_DEFAULT_PROPERTIES = "vsp-defaults.properties";
    public static final int MIN_ACL_PRIORITY = 9999;
    public static final int MAX_ACL_PRIORITY = 10000000;
    public static final int NUM_OF_PERIODIC_THREADS = 5;
    public static final int SYNC_UP_INTERVAL_IN_MINUTES = 480;
    public static final String EXTERNAL_ID_DELIMITER = "@";
    public static final Long DEFAULT_API_RETRY_COUNT = 4L;
    public static final Long DEFAULT_API_RETRY_INTERVAL = 60L;

    public static interface EnterpriseProfileDefaults {
        public static final int FLOATING_IP_QUOTA = 100;
        public static final boolean ALLOW_GATEWAY_MANAGEMENT = false;
        public static final String FWD_CLASSES = "C,D,E,F,G,H";
        public static final boolean ALLOW_ADVANCED_QOS = false;
    }

    public static enum ErrorCode implements IntCodedEnum
    {
        RESOURCE_NOT_FOUND(200),
        NO_CHANGE_IN_ENTITY(2039),
        DUPLICATE_ACL_PRIORITY(2591),
        NETWORK_MODIFICATION(2506);

        final int code;

        private ErrorCode(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum AddressSpoofing {
        ENABLED,
        DISABLED,
        INHERITED;

    }

    public static enum SharedNetworkType {
        PUBLIC,
        L2DOMAIN,
        UPLINK_SUBNET,
        FLOATING;

    }

    public static interface DefaultAcl {
        public static final int SUBNET_ALLOW_ACL_PRIORITY = 0;
        public static final int VPN_VR_ALLOW_ACL_PRIORITY = 1;
        public static final int SUBNET_BLOCK_ACL_PRIORITY = 10800000;
        public static final int ALLOW_ALL_ACL_PRIORITY = 10000001;
        public static final int DOMAIN_BLOCK_ACL_PRIORITY = 0;
        public static final Set<Integer> FIP_ACL_BLOCKED_PORTS = ImmutableSet.of((Object)80, (Object)8080, (Object)443, (Object)8443);
        public static final int FIP_ACL_BLOCK_PRIORITY = 1;
        public static final int TCP_ALLOW_ACL_PRIORITY = 1;
        public static final int UDP_ALLOW_ACL_PRIORITY = 2;
        public static final int ICMP_ALLOW_ACL_PRIORITY = 3;
        public static final String SUBNET_ALLOW_ACL = "Default Intra-Subnet Allow ACL";
        public static final String VPN_VR_ALLOW_ACL = "VPN Virtual Router Allow ACL";
        public static final String SUBNET_BLOCK_ACL = "Default Subnet ACL to block traffic as there is an ACL list associated with it";
        public static final String DOMAIN_BLOCK_ACL = "Default Intra-Domain Deny ACL";
        public static final String FIP_ACL_BLOCK = "Default Deny FIP ACL TCP Port ";
        public static final String INGRESS_ALLOW_ALL_ACL = "Default Allow All";
        public static final String INGRESS_ALLOW_TCP_ACL = "Default Allow TCP";
        public static final String INGRESS_ALLOW_UDP_ACL = "Default Allow UDP";
        public static final String INGRESS_ALLOW_ICMP_ACL = "Default Allow ICMP";
    }
}

