/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.nuage.vsp.acs.client.api.model.VspAclRule;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;

public class AclRulesDetails {
    private final Set<String> ruleUuids;
    private final List<VspAclRule> vspAclRules;
    private final boolean isNetworkAcl;
    private final Boolean isIngressFirewallRule;
    private final boolean createDefaultRules;
    private final String aclNetworkLocationId;
    private final NuageVspObject ingressAclTemplate;
    private final NuageVspObject egressAclTemplate;
    private final boolean allRulesActive;
    private final boolean needsBlockRule;
    private static final Predicate<VspAclRule> IS_ACTIVE_RULE = new Predicate<VspAclRule>(){

        public boolean apply(VspAclRule input) {
            return input.getState() == VspAclRule.ACLState.Active;
        }
    };
    private static final Predicate<VspAclRule> IS_EGRESS_ALLOW = new Predicate<VspAclRule>(){

        public boolean apply(VspAclRule input) {
            return input.getState() != VspAclRule.ACLState.Revoke && input.getAction() == VspAclRule.ACLAction.Allow && input.getTrafficType() == VspAclRule.ACLTrafficType.Egress;
        }
    };

    private Set<String> getRuleUuids() {
        HashSet<String> result = new HashSet<String>();
        if (this.vspAclRules != null) {
            for (VspAclRule rule : this.vspAclRules) {
                result.add(String.format("%s_%s", new Object[]{rule.getTrafficType(), rule.getUuid()}));
            }
        }
        return result;
    }

    public AclRulesDetails(List<VspAclRule> vspAclRules, boolean isNetworkAcl, Boolean isIngressFirewallRule, boolean createDefaultRules, String aclNetworkLocationId, NuageVspObject ingressAclTemplate, NuageVspObject egressAclTemplate) {
        this.vspAclRules = vspAclRules;
        this.isNetworkAcl = isNetworkAcl;
        this.isIngressFirewallRule = isIngressFirewallRule;
        this.createDefaultRules = createDefaultRules;
        this.aclNetworkLocationId = aclNetworkLocationId;
        this.ingressAclTemplate = ingressAclTemplate;
        this.egressAclTemplate = egressAclTemplate;
        this.allRulesActive = FluentIterable.from(vspAclRules).allMatch(IS_ACTIVE_RULE);
        this.needsBlockRule = isNetworkAcl && FluentIterable.from(vspAclRules).anyMatch(IS_EGRESS_ALLOW);
        this.ruleUuids = this.getRuleUuids();
    }

    public List<VspAclRule> getVspAclRules() {
        return this.vspAclRules;
    }

    public boolean isNetworkAcl() {
        return this.isNetworkAcl;
    }

    public Boolean isIngressFirewallRule() {
        return this.isIngressFirewallRule;
    }

    public boolean isCreateDefaultRules() {
        return this.createDefaultRules;
    }

    public String getAclNetworkLocationId() {
        return this.aclNetworkLocationId;
    }

    public NuageVspObject getIngressAclTemplate() {
        return this.ingressAclTemplate;
    }

    public NuageVspObject getEgressAclTemplate() {
        return this.egressAclTemplate;
    }

    public String getIngressAclTemplateId() {
        return this.ingressAclTemplate.getId();
    }

    public String getEgressAclTemplateId() {
        return this.egressAclTemplate.getId();
    }

    public boolean isNeedsBlockRule() {
        return this.needsBlockRule;
    }

    public boolean isAllRulesActive() {
        return this.allRulesActive;
    }

    public boolean isMissingIngressRule(NuageVspObject rule) {
        return !this.ruleUuids.contains("Ingress_" + rule.getExternalId());
    }

    public boolean isMissingEgressRule(NuageVspObject rule) {
        return !this.ruleUuids.contains("Egress_" + rule.getExternalId());
    }

    public boolean hasIngressRules() {
        return this.isIngressFirewallRule == null || this.isIngressFirewallRule == Boolean.TRUE;
    }

    public boolean hasEgressRules() {
        return this.isIngressFirewallRule == null || this.isIngressFirewallRule == Boolean.FALSE;
    }

    static enum AclType {
        ACL,
        FW_INGRESS,
        FW_EGRESS;

    }
}

