/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import net.nuage.vsp.acs.client.common.model.IntCodedEnum;

public interface Dhcp {
    public static final Set<DhcpOptionCode> defaultDhcpOptions = ImmutableSet.builder().add((Object)DhcpOptionCode.ROUTER).add((Object)DhcpOptionCode.DNS_SERVER).add((Object)DhcpOptionCode.DOMAIN_NAME).add((Object)DhcpOptionCode.SERVER_IP_ADDRESS).build();
    public static final ImmutableMap<DhcpOptionCode, DhcpOptionType> dhcpCodeToType = ImmutableMap.builder().put((Object)DhcpOptionCode.NETMASK, (Object)DhcpOptionType.IPv4).put((Object)DhcpOptionCode.ROUTER, (Object)DhcpOptionType.IPv4).put((Object)DhcpOptionCode.TIME_OFFSET, (Object)DhcpOptionType.NUMBER).put((Object)DhcpOptionCode.TIME_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.DNS_SERVER, (Object)DhcpOptionType.RAW).put((Object)DhcpOptionCode.LOG_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.LPR_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.DOMAIN_NAME, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.BOOT_FILE_SIZE, (Object)DhcpOptionType.NUMBER).put((Object)DhcpOptionCode.SWAP_SERVER, (Object)DhcpOptionType.IPv4).put((Object)DhcpOptionCode.ROOT_PATH, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.EXTENSION_PATH, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.IP_FORWARD_ENABLE, (Object)DhcpOptionType.BOOLEAN).put((Object)DhcpOptionCode.NON_LOCAL_SOURCE_ROUTING, (Object)DhcpOptionType.BOOLEAN).put((Object)DhcpOptionCode.POLICY_FILTER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.MAX_DATAGRAM_REASSEMBLY, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.DEFAULT_TTL, (Object)DhcpOptionType.NUMBER).put((Object)DhcpOptionCode.MTU, (Object)DhcpOptionType.NUMBER).put((Object)DhcpOptionCode.ALL_SUBNETS_LOCAL, (Object)DhcpOptionType.BOOLEAN).put((Object)DhcpOptionCode.BROADCAST, (Object)DhcpOptionType.IPv4).put((Object)DhcpOptionCode.ROUTER_DISCOVERY, (Object)DhcpOptionType.BOOLEAN).put((Object)DhcpOptionCode.ROUTER_SOLICITATION, (Object)DhcpOptionType.IPv4).put((Object)DhcpOptionCode.STATIC_ROUTE, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.TRAILER_ENCAPSULATION, (Object)DhcpOptionType.BOOLEAN).put((Object)DhcpOptionCode.ARP_TIMEOUT, (Object)DhcpOptionType.NUMBER).put((Object)DhcpOptionCode.ETHERNET_ENCAP, (Object)DhcpOptionType.BOOLEAN).put((Object)DhcpOptionCode.TCP_TTL, (Object)DhcpOptionType.NUMBER).put((Object)DhcpOptionCode.TCP_KEEPALIVE, (Object)DhcpOptionType.NUMBER).put((Object)DhcpOptionCode.NIS_DOMAIN, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.NIS_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.NTP_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.NETBIOS_NS, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.NETBIOS_DD, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.NETBIOS_NODETYPE, (Object)DhcpOptionType.RAW).put((Object)DhcpOptionCode.NETBIOS_SCOPE, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.X_WINDOWS_FS, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.X_WINDOWS_DM, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.REQUESTED_ADDRESS, (Object)DhcpOptionType.IPv4).put((Object)DhcpOptionCode.VENDOR_CLASS, (Object)DhcpOptionType.RAW).put((Object)DhcpOptionCode.NISPLUS_DOMAIN, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.NISPLUS_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.TFTP_SERVER, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.BOOTFILE_NAME, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.MOBILE_IP_HOME, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.SMTP_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.POP3_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.NNTP_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.IRC_SERVER, (Object)DhcpOptionType.LIST_OF_IPv4).put((Object)DhcpOptionCode.USER_CLASS, (Object)DhcpOptionType.LIST_OF_STRINGS).put((Object)DhcpOptionCode.CLIENT_ARCH, (Object)DhcpOptionType.NUMBER).put((Object)DhcpOptionCode.CLIENT_INTERFACE_ID, (Object)DhcpOptionType.RAW).put((Object)DhcpOptionCode.CLIENT_MACHINE_ID, (Object)DhcpOptionType.RAW).put((Object)DhcpOptionCode.URL, (Object)DhcpOptionType.STRING).put((Object)DhcpOptionCode.DOMAIN_SEARCH, (Object)DhcpOptionType.LIST_OF_STRINGS).put((Object)DhcpOptionCode.SIP_SERVER, (Object)DhcpOptionType.LIST_OF_STRINGS).put((Object)DhcpOptionCode.CLASSLESS_STATIC_ROUTE, (Object)DhcpOptionType.LIST_OF_STRINGS).put((Object)DhcpOptionCode.VENDOR_ID_ENCAP, (Object)DhcpOptionType.RAW).put((Object)DhcpOptionCode.SERVER_IP_ADDRESS, (Object)DhcpOptionType.RAW).build();

    public static enum DhcpOptionCode implements IntCodedEnum
    {
        NETMASK(1, "netmask"),
        TIME_OFFSET(2, "time-offset"),
        ROUTER(3, "router"),
        TIME_SERVER(4, "time-server"),
        DNS_SERVER(6, "dns-server"),
        LOG_SERVER(7, "log-server"),
        LPR_SERVER(9, "lpr-server"),
        HOSTNAME(12, "hostname"),
        BOOT_FILE_SIZE(13, "boot-file-size"),
        DOMAIN_NAME(15, "domain-name"),
        SWAP_SERVER(16, "swap-server"),
        ROOT_PATH(17, "root-path"),
        EXTENSION_PATH(18, "extension-path"),
        IP_FORWARD_ENABLE(19, "ip-forward-enable"),
        NON_LOCAL_SOURCE_ROUTING(20, "non-local-source-routing"),
        POLICY_FILTER(21, "policy-filter"),
        MAX_DATAGRAM_REASSEMBLY(22, "max-datagram-reassembly"),
        DEFAULT_TTL(23, "default-ttl"),
        MTU(26, "mtu"),
        ALL_SUBNETS_LOCAL(27, "all-subnets-local"),
        BROADCAST(28, "broadcast"),
        ROUTER_DISCOVERY(31, "router-discovery"),
        ROUTER_SOLICITATION(32, "router-solicitation"),
        STATIC_ROUTE(33, "static-route"),
        TRAILER_ENCAPSULATION(34, "trailer-encapsulation"),
        ARP_TIMEOUT(35, "arp-timeout"),
        ETHERNET_ENCAP(36, "ethernet-encap"),
        TCP_TTL(37, "tcp-ttl"),
        TCP_KEEPALIVE(38, "tcp-keepalive"),
        NIS_DOMAIN(40, "nis-domain"),
        NIS_SERVER(41, "nis-server"),
        NTP_SERVER(42, "ntp-server"),
        VENDOR_ENCAP(43, "vendor-encap"),
        NETBIOS_NS(44, "netbios-ns"),
        NETBIOS_DD(45, "netbios-dd"),
        NETBIOS_NODETYPE(46, "netbios-nodetype"),
        NETBIOS_SCOPE(47, "netbios-scope"),
        X_WINDOWS_FS(48, "x-windows-fs"),
        X_WINDOWS_DM(49, "x-windows-dm"),
        REQUESTED_ADDRESS(50, "requested-address"),
        LEASE_TIME(51, "lease-time"),
        OPTION_OVERLOAD(52, "option-overload"),
        MESSAGE_TYPE(53, "message-type"),
        SERVER_IDENTIFIER(54, "server-identifier"),
        PARAMETER_REQUEST(55, "parameter-request"),
        MESSAGE(56, "message"),
        MAX_MESSAGE_SIZE(57, "max-message-size"),
        T1(58, "T1"),
        T2(59, "T2"),
        VENDOR_CLASS(60, "vendor-class"),
        CLIENT_ID(61, "client-id"),
        NISPLUS_DOMAIN(64, "nis+-domain"),
        NISPLUS_SERVER(65, "nis+-server"),
        TFTP_SERVER(66, "tftp-server"),
        BOOTFILE_NAME(67, "bootfile-name"),
        MOBILE_IP_HOME(68, "mobile-ip-home"),
        SMTP_SERVER(69, "smtp-server"),
        POP3_SERVER(70, "pop3-server"),
        NNTP_SERVER(71, "nntp-server"),
        IRC_SERVER(74, "irc-server"),
        USER_CLASS(77, "user-class"),
        FQDN(81, "FQDN"),
        AGENT_ID(82, "agent-id"),
        CLIENT_ARCH(93, "client-arch"),
        CLIENT_INTERFACE_ID(94, "client-interface-id"),
        CLIENT_MACHINE_ID(97, "client-machine-id"),
        SUBNET_SELECT(118, "subnet-select"),
        URL(114, "url"),
        DOMAIN_SEARCH(119, "domain-search"),
        SIP_SERVER(120, "sip-server"),
        CLASSLESS_STATIC_ROUTE(121, "classless-static-route"),
        VENDOR_ID_ENCAP(125, "vendor-id-encap"),
        SERVER_IP_ADDRESS(255, "server-ip-address");

        private int code;
        private String name;

        private DhcpOptionCode(int code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public static DhcpOptionCode valueOf(int code) {
            return Arrays.stream(DhcpOptionCode.values()).filter(option -> option.getCode() == code).findFirst().orElseThrow(() -> new IllegalArgumentException("DhcpOptionCode not found."));
        }
    }

    public static enum DhcpOptionType {
        BOOLEAN,
        NUMBER,
        IPv4,
        LIST_OF_IPv4,
        LIST_OF_STRINGS,
        RAW,
        STRING;

    }
}

