/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.nuage.vsp.acs.client.api.model.Protocol;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.NuageVspConstants;
import net.nuage.vsp.acs.client.common.model.Acl;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.model.gson.NuageVspObjectTypeAdapter;

public enum NuageVspAttribute {
    ID("ID", (Type)((Object)String.class)),
    EXTERNAL_ID("externalID", (Type)((Object)String.class)),
    CMS_ID("cmsId", (Type)((Object)String.class)),
    VERSION("version", (Type)((Object)String.class)),
    VERSION_STATUS("status", (Type)((Object)NuageVspApiVersion.Status.class)),
    PARENT_ID("parentID", (Type)((Object)String.class)),
    TEMPLATE_ID("templateID", (Type)((Object)String.class)),
    APIKEY("APIKey", (Type)((Object)String.class)),
    ENTERPRISE_ID("enterpriseID", (Type)((Object)String.class)),
    LASTUPDATED("lastUpdatedDate", (Type)((Object)String.class)),
    NAME("name", (Type)((Object)String.class)),
    DESCRIPTION("description", (Type)((Object)String.class)),
    ENTERPRISE_PROFILE_ID("enterpriseProfileID", (Type)((Object)String.class)),
    GROUP_PRIVATE("private", (Type)((Object)String.class)),
    GROUP_ROLE("role", (Type)((Object)String.class)),
    USER_USERNAME("userName", (Type)((Object)String.class)),
    USER_FIRSTNAME("firstName", (Type)((Object)String.class)),
    USER_LASTNAME("lastName", (Type)((Object)String.class)),
    USER_PASSWORD("password", (Type)((Object)String.class)),
    USER_EMAIL("email", (Type)((Object)String.class)),
    L2DOMAIN_TEMPLATE_ADDRESS("address", (Type)((Object)String.class)),
    L2DOMAIN_TEMPLATE_NETMASK("netmask", (Type)((Object)String.class)),
    L2DOMAIN_TEMPLATE_GATEWAY("gateway", (Type)((Object)String.class)),
    DOMAIN_PATENABLED("PATEnabled", (Type)((Object)Boolean.class)),
    DOMAIN_UNDERLAYENABLED("underlayEnabled", (Type)((Object)Boolean.class)),
    ZONE_PUBLIC("publicZone", (Type)((Object)String.class)),
    SUBNET_ADDRESS("address", (Type)((Object)String.class)),
    SUBNET_NETMASK("netmask", (Type)((Object)String.class)),
    SUBNET_GATEWAY("gateway", (Type)((Object)String.class)),
    ADDRESS_RANGE_MIN("minAddress", (Type)((Object)String.class)),
    ADDRESS_RANGE_MAX("maxAddress", (Type)((Object)String.class)),
    L2DOMAIN_ADDRESS("address", (Type)((Object)String.class)),
    L2DOMAIN_NETMASK("netmask", (Type)((Object)String.class)),
    L2DOMAIN_GATEWAY("gateway", (Type)((Object)String.class)),
    DHCP_OPTIONS_LENGTH("length", (Type)((Object)String.class)),
    DHCP_OPTIONS_TYPE("type", (Type)((Object)String.class)),
    DHCP_OPTIONS_VALUE("value", (Type)((Object)String.class)),
    DHCP_OPTIONS_ACTUAL_TYPE("actualType", (Type)((Object)Integer.class)),
    DHCP_OPTIONS_ACTUAL_VALUES("actualValues", Types.LIST_OF_STRINGS),
    ACLTEMPLATES_ACTIVE("active", (Type)((Object)Boolean.class)),
    ACLTEMPLATES_PRIORITY("priority", (Type)((Object)Integer.class)),
    ACLTEMPLATES_PRIORITY_TYPE("priorityType", (Type)((Object)Acl.AclTemplatePriorityType.class)),
    ACLTEMPLATES_POLICY_STATE("policyState", (Type)((Object)Acl.AclPolicyState.class)),
    ACLTEMPLATES_ENTRIES("ACLEntries", NuageVspObjectTypeAdapter.LIST_TYPE),
    ACLTEMPLATES_ALLOW_NON_IP("defaultAllowNonIP", (Type)((Object)Boolean.class)),
    ACLTEMPLATES_ALLOW_IP("defaultAllowIP", (Type)((Object)Boolean.class)),
    ACLTEMPLATES_ENTRY_LOCATION_TYPE("locationType", (Type)((Object)Acl.AclEntryLocationType.class)),
    ACLTEMPLATES_ENTRY_NETWORK_TYPE("networkType", (Type)((Object)Acl.AclEntryNetworkType.class)),
    ACLTEMPLATES_ENTRY_LOCATION_ID("locationID", (Type)((Object)String.class)),
    ACLTEMPLATES_ENTRY_NETWORK_ID("networkID", (Type)((Object)String.class)),
    ACLTEMPLATES_ENTRY_SOURCE_PORT("sourcePort", (Type)((Object)String.class)),
    ACLTEMPLATES_ENTRY_DEST_PORT("destinationPort", (Type)((Object)String.class)),
    ACLTEMPLATES_ENTRY_PROTOCOL("protocol", (Type)((Object)Protocol.class)),
    ACLTEMPLATES_ENTRY_PRIORITY("priority", (Type)((Object)Integer.class)),
    ACLTEMPLATES_ENTRY_ACTION("action", (Type)((Object)Acl.AclAction.class)),
    ACLTEMPLATES_ENTRY_ETHER_TYPE("etherType", (Type)((Object)Acl.AclEtherType.class)),
    ACLTEMPLATES_ENTRY_ADDR_OVERRIDE("addressOverride", (Type)((Object)String.class)),
    ACLTEMPLATES_ENTRY_REFLEXIVE((Map<NuageVspApiVersion, String>)ImmutableMap.of((Object)NuageVspApiVersion.V3_2, (Object)"reflexive", (Object)NuageVspApiVersion.V4_0, (Object)"stateful")),
    ACLTEMPLATES_ENTRY_DSCP("DSCP", (Type)((Object)String.class)),
    FIP_RATE_LIMITING_QOS_FIP_PEAK_INFORMATION_RATE("FIPPeakInformationRate", (Type)((Object)String.class)),
    FIP_RATE_LIMITING_QOS_FIP_RATE_LIMITING_ACTIVE("FIPRateLimitingActive", (Type)((Object)String.class)),
    FIP_RATE_LIMITING_QOS_FIP_PEAK_BURST_SIZE("FIPPeakBurstSize", (Type)((Object)String.class)),
    FIP_RATE_LIMITING_QOS_ACTIVE("active", (Type)((Object)Boolean.class)),
    VM_UUID("UUID", (Type)((Object)String.class)),
    VM_STATUS("status", (Type)((Object)String.class)),
    VM_INTERFACES("interfaces", NuageVspObjectTypeAdapter.LIST_TYPE),
    VM_INTERFACE_MAC("MAC", (Type)((Object)String.class)),
    VM_INTERFACE_ATTACHED_NETWORK_ID("attachedNetworkID", (Type)((Object)String.class)),
    VM_INTERFACE_ATTACHED_NETWORK_TYPE("attachedNetworkType", (Type)((Object)String.class)),
    VM_INTERFACE_GATEWAY("gateway", (Type)((Object)String.class)),
    VM_INTERFACE_IPADDRESS("IPAddress", (Type)((Object)String.class)),
    VM_INTERFACE_NETMASK("netmask", (Type)((Object)String.class)),
    VM_INTERFACE_VPORT_ID("VPortID", (Type)((Object)String.class)),
    VM_INTERFACE_DOMAIN_ID("domainID", (Type)((Object)String.class)),
    VM_INTERFACE_DOMAIN_NAME("domainName", (Type)((Object)String.class)),
    VM_INTERFACE_ZONE_NAME("zoneName", (Type)((Object)String.class)),
    VM_INTERFACE_NETWORK_NAME("networkName", (Type)((Object)String.class)),
    VM_INTERFACE_VPORT_NAME("VPortName", (Type)((Object)String.class)),
    VM_INTERFACE_ASSOCIATED_FIP("associatedFloatingIPAddress", (Type)((Object)String.class)),
    VM_INTERFACE_VM_UUID("VMUUID", (Type)((Object)String.class)),
    SHARED_RESOURCE_ADRESS("address", (Type)((Object)String.class)),
    SHARED_RESOURCE_GATEWAY("gateway", (Type)((Object)String.class)),
    SHARED_RESOURCE_NETMASK("netmask", (Type)((Object)String.class)),
    SHARED_RESOURCE_TYPE("type", (Type)((Object)NuageVspConstants.SharedNetworkType.class)),
    SHARED_RESOURCE_UNDERLAY("underlay", (Type)((Object)Boolean.class)),
    SHARED_RESOURCE_PARENT_ID("sharedResourceParentID", (Type)((Object)String.class)),
    ASSOC_SHARED_NTWK_ID("associatedSharedNetworkResourceID", (Type)((Object)String.class)),
    FLOATING_IP_ADDRESS("address", (Type)((Object)String.class)),
    FLOATING_IP_ASSIGNED("assigned", (Type)((Object)String.class)),
    FLOATING_IP_ACCESS_CONTROL("accessControl", (Type)((Object)String.class)),
    VIRTUAL_IP_MAC("MAC", (Type)((Object)String.class)),
    VIRTUAL_IP_ADDRESS("virtualIP", (Type)((Object)String.class)),
    VIRTUAL_IP_FLOATING_IP_ID("associatedFloatingIPID", (Type)((Object)String.class)),
    VPORT_TYPE("type", (Type)((Object)String.class)),
    VPORT_ACTIVE("active", (Type)((Object)String.class)),
    VPORT_ADDRESSSPOOFING("addressSpoofing", (Type)((Object)NuageVspConstants.AddressSpoofing.class)),
    VPORT_FLOATING_IP_ID("associatedFloatingIPID", (Type)((Object)String.class)),
    ENTERPRISE_NTWK_MACRO_ADDRESS("address", (Type)((Object)String.class)),
    ENTERPRISE_NTWK_MACRO_NETMASK("netmask", (Type)((Object)String.class)),
    ENTERPRISE_PROFILE_FLOATING_IP_QUOTA("floatingIPsQuota", (Type)((Object)String.class)),
    ENTERPRISE_PROFILE_GATEWAY_MGMT("allowGatewayManagement", (Type)((Object)String.class)),
    ENTERPRISE_PROFILE_FWD_CLASSES("allowedForwardingClasses", Types.LIST_OF_STRINGS),
    ENTERPRISE_PROFILE_ADV_QOS("allowAdvancedQOSConfiguration", (Type)((Object)String.class)),
    POLICY_GROUP_TYPE("type", (Type)((Object)String.class)),
    POLICY_GROUP_EXTERNAL("external", (Type)((Object)String.class)),
    GATEWAY_SYSTEMID("systemID", (Type)((Object)String.class)),
    WAN_SERVICE_VPN_CONNECT_ID("associatedVPNConnectID", (Type)((Object)String.class)),
    VPN_CONNECTION_WANSERVICE_ID("associatedWANServiceID", (Type)((Object)String.class)),
    STATIC_ROUTE_ADDRESS("address", (Type)((Object)String.class)),
    STATIC_ROUTE_NETMASK("netmask", (Type)((Object)String.class)),
    STATIC_ROUTE_NEXTHOP("nextHopIp", (Type)((Object)String.class)),
    ENTERPRISEPERMISSION_PERMITTED_ENTITYID("permittedEntityID", (Type)((Object)String.class)),
    ENTERPRISEPERMISSION_PERMITTED_ENTITYYPE("permittedEntityType", (Type)((Object)String.class)),
    ENTERPRISEPERMISSION_PERMITTED_ACTION("permittedAction", (Type)((Object)String.class));

    private static Map<NuageVspApiVersion, Map<String, NuageVspAttribute>> lookup;
    private Type type;
    private Map<NuageVspApiVersion, String> attributeName = Maps.newHashMap();

    private NuageVspAttribute(String attributeName, Type type) {
        for (NuageVspApiVersion apiVersion : NuageVspApiVersion.SUPPORTED_VERSIONS) {
            this.attributeName.put(apiVersion, attributeName);
        }
        this.type = type;
    }

    private NuageVspAttribute(Map<NuageVspApiVersion, String> attributeNames, Type type) {
        if (attributeNames.size() > NuageVspApiVersion.SUPPORTED_VERSIONS.length) {
            throw new IllegalArgumentException("Can't specify more attribute names (" + attributeNames.size() + ") than there are supported versions (" + NuageVspApiVersion.SUPPORTED_VERSIONS.length + ")");
        }
        for (NuageVspApiVersion apiVersion : NuageVspApiVersion.SUPPORTED_VERSIONS) {
            if (!attributeNames.containsKey(apiVersion)) {
                throw new IllegalArgumentException("Please specify the attribute name for each supported version. Attribute " + this.name() + " is missing attribute name for " + apiVersion);
            }
            this.attributeName.put(apiVersion, attributeNames.get(apiVersion));
        }
        this.type = type;
    }

    private NuageVspAttribute(Map<NuageVspApiVersion, String> attributeNames) {
        this(attributeNames, (Type)((Object)String.class));
    }

    @Deprecated
    public String getAttributeName() {
        return this.attributeName.get(NuageVspApiVersion.CURRENT);
    }

    public <T> T get(NuageVspObject nuageVspObject) {
        return nuageVspObject.get(this);
    }

    public String getAttributeName(NuageVspApiVersion apiVersion) {
        return this.attributeName.get(apiVersion);
    }

    public static NuageVspAttribute lookup(NuageVspApiVersion apiVersion, String attributeName, NuageVspEntity entityType) {
        for (NuageVspAttribute attr : entityType.getAttributes()) {
            if (!attr.getAttributeName(apiVersion).equals(attributeName)) continue;
            return attr;
        }
        return null;
    }

    public String toString() {
        return this.getAttributeName(NuageVspApiVersion.CURRENT);
    }

    public Type getType() {
        return this.type;
    }

    static {
        lookup = new HashMap<NuageVspApiVersion, Map<String, NuageVspAttribute>>();
        for (NuageVspApiVersion apiVersion : NuageVspApiVersion.SUPPORTED_VERSIONS) {
            HashMap<String, NuageVspAttribute> attributes = new HashMap<String, NuageVspAttribute>();
            lookup.put(apiVersion, attributes);
            for (NuageVspAttribute attribute : NuageVspAttribute.values()) {
                attributes.put(attribute.getAttributeName(apiVersion), attribute);
            }
        }
    }

    private static class Types {
        public static final Type LIST_OF_STRINGS = new TypeToken<List<String>>(){}.getType();

        private Types() {
        }
    }
}

