/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;

public enum NuageVspEntity {
    VERSION("", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.VERSION, NuageVspAttribute.VERSION_STATUS),
    ME("me", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.APIKEY, NuageVspAttribute.ENTERPRISE_ID),
    ENTERPRISE("enterprises", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.ENTERPRISE_PROFILE_ID, NuageVspAttribute.LASTUPDATED),
    GROUP("groups", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.GROUP_ROLE),
    USER("users", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.USER_USERNAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.USER_EMAIL, NuageVspAttribute.USER_PASSWORD, NuageVspAttribute.USER_FIRSTNAME, NuageVspAttribute.USER_LASTNAME),
    L2DOMAIN_TEMPLATE("l2domaintemplates", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.L2DOMAIN_TEMPLATE_ADDRESS, NuageVspAttribute.L2DOMAIN_TEMPLATE_NETMASK, NuageVspAttribute.L2DOMAIN_TEMPLATE_GATEWAY),
    DOMAIN_TEMPLATE("domaintemplates", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.LASTUPDATED),
    ZONE_TEMPLATE("zonetemplates", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.LASTUPDATED),
    INGRESS_ACLTEMPLATES("ingressacltemplates", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, NuageVspAttribute.ACLTEMPLATES_PRIORITY, NuageVspAttribute.ACLTEMPLATES_ACTIVE, NuageVspAttribute.ACLTEMPLATES_ENTRIES, NuageVspAttribute.ACLTEMPLATES_ALLOW_IP, NuageVspAttribute.ACLTEMPLATES_ALLOW_NON_IP),
    INGRESS_ACLTEMPLATES_ENTRIES("ingressaclentrytemplates", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.ID, NuageVspAttribute.EXTERNAL_ID, NuageVspAttribute.CMS_ID, NuageVspAttribute.PARENT_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, NuageVspAttribute.LASTUPDATED),
    EGRESS_ACLTEMPLATES("egressacltemplates", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, NuageVspAttribute.ACLTEMPLATES_PRIORITY, NuageVspAttribute.ACLTEMPLATES_ACTIVE, NuageVspAttribute.ACLTEMPLATES_ENTRIES, NuageVspAttribute.ACLTEMPLATES_ALLOW_IP, NuageVspAttribute.ACLTEMPLATES_ALLOW_NON_IP),
    EGRESS_ACLTEMPLATES_ENTRIES("egressaclentrytemplates", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.PARENT_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, NuageVspAttribute.LASTUPDATED),
    EGRESS_DOMAIN_FIP_ACLTEMPLATES("egressdomainfloatingipacltemplates", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, NuageVspAttribute.ACLTEMPLATES_PRIORITY, NuageVspAttribute.ACLTEMPLATES_ACTIVE, NuageVspAttribute.ACLTEMPLATES_ENTRIES),
    EGRESS_DOMAIN_FIP_ACLTEMPLATES_ENTRIES("egressdomainfloatingipaclentrytemplates", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.PARENT_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, NuageVspAttribute.LASTUPDATED),
    FIP_RATE_LIMITING_QOS("qos", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.FIP_RATE_LIMITING_QOS_ACTIVE, NuageVspAttribute.FIP_RATE_LIMITING_QOS_FIP_RATE_LIMITING_ACTIVE, NuageVspAttribute.FIP_RATE_LIMITING_QOS_FIP_PEAK_INFORMATION_RATE, NuageVspAttribute.FIP_RATE_LIMITING_QOS_FIP_PEAK_BURST_SIZE, NuageVspAttribute.LASTUPDATED),
    DOMAIN("domains", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.TEMPLATE_ID, NuageVspAttribute.LASTUPDATED, NuageVspAttribute.DOMAIN_PATENABLED, NuageVspAttribute.DOMAIN_UNDERLAYENABLED),
    ZONE("zones", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.LASTUPDATED, NuageVspAttribute.ZONE_PUBLIC),
    SUBNET("subnets", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.SUBNET_ADDRESS, NuageVspAttribute.SUBNET_NETMASK, NuageVspAttribute.SUBNET_GATEWAY, NuageVspAttribute.LASTUPDATED, NuageVspAttribute.ASSOC_SHARED_NTWK_ID),
    ADDRESS_RANGE("addressranges", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.ADDRESS_RANGE_MIN, NuageVspAttribute.ADDRESS_RANGE_MAX),
    L2DOMAIN("l2domains", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.TEMPLATE_ID, NuageVspAttribute.L2DOMAIN_ADDRESS, NuageVspAttribute.L2DOMAIN_NETMASK, NuageVspAttribute.L2DOMAIN_GATEWAY),
    VM("vms", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.VM_UUID, NuageVspAttribute.VM_STATUS, NuageVspAttribute.VM_INTERFACES),
    VM_INTERFACE("vminterfaces", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.VM_INTERFACE_MAC, NuageVspAttribute.VM_INTERFACE_ATTACHED_NETWORK_ID, NuageVspAttribute.VM_INTERFACE_ATTACHED_NETWORK_TYPE, NuageVspAttribute.VM_INTERFACE_GATEWAY, NuageVspAttribute.VM_INTERFACE_IPADDRESS, NuageVspAttribute.VM_INTERFACE_NETMASK, NuageVspAttribute.VM_INTERFACE_DOMAIN_ID, NuageVspAttribute.VM_INTERFACE_VPORT_ID, NuageVspAttribute.VM_INTERFACE_DOMAIN_NAME, NuageVspAttribute.VM_INTERFACE_ZONE_NAME, NuageVspAttribute.VM_INTERFACE_NETWORK_NAME, NuageVspAttribute.VM_INTERFACE_VPORT_NAME, NuageVspAttribute.VM_INTERFACE_ASSOCIATED_FIP, NuageVspAttribute.VM_INTERFACE_VM_UUID),
    SHARED_NETWORK("sharednetworkresources", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.PARENT_ID, NuageVspAttribute.SHARED_RESOURCE_ADRESS, NuageVspAttribute.SHARED_RESOURCE_GATEWAY, NuageVspAttribute.SHARED_RESOURCE_NETMASK, NuageVspAttribute.SHARED_RESOURCE_TYPE, NuageVspAttribute.SHARED_RESOURCE_UNDERLAY, NuageVspAttribute.SHARED_RESOURCE_PARENT_ID),
    FLOATING_IP("floatingips", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.FLOATING_IP_ADDRESS, NuageVspAttribute.ASSOC_SHARED_NTWK_ID, NuageVspAttribute.FLOATING_IP_ASSIGNED, NuageVspAttribute.LASTUPDATED),
    VPORT("vports", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.VPORT_FLOATING_IP_ID, NuageVspAttribute.VPORT_ACTIVE, NuageVspAttribute.VPORT_TYPE, NuageVspAttribute.VPORT_ADDRESSSPOOFING, NuageVspAttribute.LASTUPDATED),
    VIRTUAL_IP("virtualips", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.VIRTUAL_IP_ADDRESS, NuageVspAttribute.VIRTUAL_IP_FLOATING_IP_ID, NuageVspAttribute.VIRTUAL_IP_MAC),
    ENTERPRISE_NTWK_MACRO("enterprisenetworks", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.ENTERPRISE_NTWK_MACRO_ADDRESS, NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NETMASK),
    ENTERPRISE_NTWK_MACRO_GROUP("networkmacrogroups", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), new NuageVspAttribute[0]),
    ENTERPRISE_PROFILE("enterpriseprofiles", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.ENTERPRISE_PROFILE_ADV_QOS, NuageVspAttribute.ENTERPRISE_PROFILE_FLOATING_IP_QUOTA, NuageVspAttribute.ENTERPRISE_PROFILE_FWD_CLASSES, NuageVspAttribute.ENTERPRISE_PROFILE_GATEWAY_MGMT),
    POLICY_GROUP_TEMPLATE("policygrouptemplates", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.POLICY_GROUP_TYPE, NuageVspAttribute.POLICY_GROUP_EXTERNAL),
    POLICY_GROUP("policygroups", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.DESCRIPTION)), NuageVspAttribute.POLICY_GROUP_TYPE, NuageVspAttribute.POLICY_GROUP_EXTERNAL, NuageVspAttribute.TEMPLATE_ID),
    DHCP_OPTIONS("dhcpoptions", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.DHCP_OPTIONS_TYPE, NuageVspAttribute.DHCP_OPTIONS_LENGTH, NuageVspAttribute.DHCP_OPTIONS_VALUE, NuageVspAttribute.DHCP_OPTIONS_ACTUAL_TYPE, NuageVspAttribute.DHCP_OPTIONS_ACTUAL_VALUES),
    GATEWAY("gateways", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.GATEWAY_SYSTEMID),
    WAN_SERVICES("services", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.WAN_SERVICE_VPN_CONNECT_ID),
    VPN_CONNECTION("vpnconnections", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.VPN_CONNECTION_WANSERVICE_ID),
    ENTERPRISEPERMISSION("enterprisepermissions", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.ENTERPRISEPERMISSION_PERMITTED_ENTITYID, NuageVspAttribute.ENTERPRISEPERMISSION_PERMITTED_ENTITYYPE, NuageVspAttribute.ENTERPRISEPERMISSION_PERMITTED_ACTION),
    STATIC_ROUTE("staticroutes", (Optional<NuageVspAttribute>)Optional.absent(), (Optional<NuageVspAttribute>)Optional.absent(), NuageVspAttribute.STATIC_ROUTE_ADDRESS, NuageVspAttribute.STATIC_ROUTE_NETMASK, NuageVspAttribute.STATIC_ROUTE_NEXTHOP),
    CLOUD_MGMT_SYSTEMS("cms", (Optional<NuageVspAttribute>)Optional.of((Object)((Object)NuageVspAttribute.NAME)), (Optional<NuageVspAttribute>)Optional.absent(), new NuageVspAttribute[0]);

    public static final Function<NuageVspAttribute, String> GET_ATTRIBUTE_NAME;
    private String entityType;
    private Optional<NuageVspAttribute> name;
    private Optional<NuageVspAttribute> description;
    private Set<NuageVspAttribute> attributes;
    private static Map<String, NuageVspEntity> lookup;

    private NuageVspEntity(String entityType, Optional<NuageVspAttribute> name, Optional<NuageVspAttribute> description, NuageVspAttribute ... attributes) {
        this.entityType = entityType;
        this.name = name;
        this.description = description;
        HashSet nuageVspAttributes = Sets.newHashSet((Object[])attributes);
        if (name.isPresent()) {
            nuageVspAttributes.add(name.get());
        }
        if (description.isPresent()) {
            nuageVspAttributes.add(description.get());
        }
        nuageVspAttributes.add(NuageVspAttribute.ID);
        nuageVspAttributes.add(NuageVspAttribute.EXTERNAL_ID);
        nuageVspAttributes.add(NuageVspAttribute.PARENT_ID);
        nuageVspAttributes.add(NuageVspAttribute.CMS_ID);
        nuageVspAttributes.add(NuageVspAttribute.LASTUPDATED);
        this.attributes = Sets.immutableEnumSet((Iterable)nuageVspAttributes);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Set<NuageVspAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(NuageVspAttribute field) {
        return this.attributes.contains((Object)field);
    }

    public Collection<String> getAttributeNameList(final NuageVspApiVersion apiVersion) {
        return Collections2.transform(this.getAttributes(), (Function)new Function<NuageVspAttribute, String>(){

            public String apply(NuageVspAttribute input) {
                return input.getAttributeName(apiVersion);
            }
        });
    }

    public static NuageVspEntity lookup(String entityType) throws Exception {
        NuageVspEntity nuageEntity = lookup.get(entityType);
        if (nuageEntity == null) {
            throw new Exception("Entity " + entityType + " is not supported by Nuage");
        }
        return nuageEntity;
    }

    public Optional<NuageVspAttribute> getNameAttribute() {
        return this.name;
    }

    public Optional<NuageVspAttribute> getDescriptionAttribute() {
        return this.description;
    }

    public String getName() {
        return (String)this.name.transform(GET_ATTRIBUTE_NAME).or((Object)"");
    }

    public String getDescription() {
        return (String)this.description.transform(GET_ATTRIBUTE_NAME).or((Object)"");
    }

    static {
        GET_ATTRIBUTE_NAME = new Function<NuageVspAttribute, String>(){

            public String apply(NuageVspAttribute nuageVspAttribute) {
                return nuageVspAttribute.getAttributeName();
            }
        };
        lookup = new HashMap<String, NuageVspEntity>();
        for (NuageVspEntity entity : NuageVspEntity.values()) {
            lookup.put(entity.getEntityType(), entity);
        }
    }
}

