/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.nuage.vsp.acs.client.common.FilterProcessor;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import org.apache.commons.lang.StringUtils;

public class NuageVspFilter {
    private FilterBuilderStrategy filterBuilderStrategy = new VspFilterBuilderStrategy(NuageVspApiVersion.CURRENT);
    private Filter filter;
    private LinkedList<Filter> filterStack = new LinkedList();
    private LinkedList<OrderBy> orderByList = new LinkedList();

    private NuageVspFilter addFilter(Filter aFilter) {
        if (this.filter != null) {
            this.filter.addFilter(aFilter);
        } else {
            this.filter = aFilter;
        }
        return this;
    }

    public static NuageVspFilter where() {
        return new NuageVspFilter();
    }

    public NuageVspFilter orderBy(NuageVspAttribute attribute, OrderType type) {
        this.orderByList.add(new OrderBy(attribute, type));
        return this;
    }

    @Deprecated
    public static NuageVspFilter where(String legacyFilter) {
        NuageVspFilter f = new NuageVspFilter();
        f.filter = new LegacyFilter(legacyFilter);
        return f;
    }

    public static BinaryOperatorBuilder where(NuageVspAttribute attribute) {
        return NuageVspFilter.where().field(attribute);
    }

    public NuageVspFilter not(Function<NuageVspFilter, NuageVspFilter> consumer) {
        this.filterStack.push(this.filter);
        this.filter = null;
        consumer.apply((Object)this);
        Filter currentFilter = this.filter;
        this.filter = this.filterStack.pop();
        this.addFilter(new UnaryOperator(UnaryOp.NOT, currentFilter));
        return this;
    }

    private NuageVspFilter startGroup(GroupOp op) {
        if (this.filter != null && !this.filter.accept(op)) {
            this.filter = new GroupOperator(op, this.filter, !this.filterStack.isEmpty());
        }
        return this;
    }

    public BinaryOperatorBuilder and(NuageVspAttribute attribute) {
        return this.and().field(attribute);
    }

    public NuageVspFilter and() {
        return this.startGroup(GroupOp.AND);
    }

    public BinaryOperatorBuilder or(NuageVspAttribute attribute) {
        return this.or().field(attribute);
    }

    public NuageVspFilter or() {
        return this.startGroup(GroupOp.OR);
    }

    public BinaryOperatorBuilder field(NuageVspAttribute attribute) {
        return new BinaryOperatorBuilder(attribute);
    }

    public NuageVspFilter op() {
        this.filterStack.push(this.filter);
        this.filter = null;
        return this;
    }

    public NuageVspFilter cp() {
        Filter currentFilter = this.filter;
        this.filter = this.filterStack.pop();
        this.addFilter(currentFilter);
        return this;
    }

    public void applyCmsId(String cmsId) {
        if (this.filter != null) {
            this.filter.applyCmsId(cmsId);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.filter.appendFilter(sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public String getFilterString(NuageVspApiVersion apiVersion) {
        this.filterBuilderStrategy = new VspFilterBuilderStrategy(apiVersion);
        return this.toString();
    }

    public String getFilterString(FilterBuilderStrategy strategy) {
        this.filterBuilderStrategy = strategy;
        return this.toString();
    }

    public boolean hasOrderBy() {
        return !this.orderByList.isEmpty();
    }

    public String getOrderByString(FilterBuilderStrategy strategy) {
        this.filterBuilderStrategy = strategy;
        return this.getOrderByString();
    }

    public String getOrderByString() {
        if (this.orderByList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            Iterator orderBys = this.orderByList.iterator();
            if (orderBys.hasNext()) {
                ((OrderBy)orderBys.next()).appendOrderBy(sb);
                while (orderBys.hasNext()) {
                    sb.append(", ");
                    ((OrderBy)orderBys.next()).appendOrderBy(sb);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public class BinaryOperatorBuilder {
        NuageVspAttribute attribute;

        private BinaryOperatorBuilder(NuageVspAttribute attribute) {
            this.attribute = attribute;
        }

        public NuageVspFilter eq(Object value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.EQ, value));
        }

        public NuageVspFilter gt(Object value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.GT, value));
        }

        public NuageVspFilter lt(Object value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.LT, value));
        }

        public NuageVspFilter ge(Object value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.GE, value));
        }

        public NuageVspFilter le(Object value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.LE, value));
        }

        public NuageVspFilter ne(Object value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.NE, value));
        }

        public NuageVspFilter startsWith(String value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.STARTS_WITH, value));
        }

        public NuageVspFilter endsWith(String value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.ENDS_WITH, value));
        }

        public NuageVspFilter contains(String value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.CONTAINS, value));
        }

        public NuageVspFilter like(String value) {
            return NuageVspFilter.this.addFilter(new BinaryOperator(this.attribute, BinaryOp.LIKE, value));
        }
    }

    private class BinaryOperator
    implements Filter {
        NuageVspAttribute attribute;
        BinaryOp operator;
        Object value;

        public BinaryOperator(NuageVspAttribute attribute, BinaryOp operator, Object value) {
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }

        @Override
        public void appendFilter(StringBuilder sb) throws IOException {
            NuageVspFilter.this.filterBuilderStrategy.appendField(sb, this.attribute);
            sb.append(" ");
            NuageVspFilter.this.filterBuilderStrategy.appendBinaryOperator(sb, this.operator, this.value);
        }

        @Override
        public void applyCmsId(String cmsId) {
            if (FilterProcessor.EXTERNAL_ID_FIELDS.contains((Object)this.attribute) && this.operator == BinaryOp.EQ) {
                String externalId = (String)this.value;
                if (externalId.contains("@")) {
                    String oldCmsId = StringUtils.substringAfter((String)externalId, (String)"@");
                    if (oldCmsId.equals(cmsId)) {
                        return;
                    }
                    this.value = StringUtils.substringBefore((String)externalId, (String)"@");
                }
                this.value = this.value + "@" + cmsId;
            }
        }
    }

    private class GroupOperator
    implements Filter {
        GroupOp operator;
        List<Filter> filters;
        boolean parantheses;

        public GroupOperator(GroupOp operator, List<Filter> filters) {
            this.operator = operator;
            this.filters = new LinkedList<Filter>(filters);
        }

        public GroupOperator(GroupOp operator, Filter filter, boolean parantheses) {
            this.operator = operator;
            this.filters = new LinkedList<Filter>();
            this.filters.add(filter);
            this.parantheses = parantheses;
        }

        @Override
        public void addFilter(Filter filter) {
            this.filters.add(filter);
        }

        public void withParantheses() {
            this.parantheses = true;
        }

        @Override
        public void applyCmsId(String cmsId) {
            for (Filter filter : this.filters) {
                filter.applyCmsId(cmsId);
            }
        }

        @Override
        public void appendFilter(StringBuilder sb) throws IOException {
            Iterator<Filter> parts = this.filters.iterator();
            if (this.parantheses) {
                sb.append("(");
            }
            if (parts.hasNext()) {
                parts.next().appendFilter(sb);
                while (parts.hasNext()) {
                    sb.append(" ").append(this.operator.name()).append(" ");
                    parts.next().appendFilter(sb);
                }
            }
            if (this.parantheses) {
                sb.append(")");
            }
        }

        @Override
        public boolean accept(GroupOp op) {
            return op == this.operator;
        }
    }

    private class UnaryOperator
    implements Filter {
        UnaryOp operator;
        Filter filter;

        public UnaryOperator(UnaryOp operator, Filter filter) {
            this.operator = operator;
            this.filter = filter;
        }

        @Override
        public void addFilter(Filter filter) {
            this.filter = filter;
        }

        @Override
        public void applyCmsId(String cmsId) {
            this.filter.applyCmsId(cmsId);
        }

        @Override
        public void appendFilter(StringBuilder sb) throws IOException {
            switch (this.operator) {
                case NOT: {
                    sb.append("NOT");
                    if (!(this.filter instanceof GroupOperator)) {
                        sb.append("(");
                    }
                    this.filter.appendFilter(sb);
                    if (this.filter instanceof GroupOperator) break;
                    sb.append(")");
                }
            }
        }
    }

    private static class LegacyFilter
    implements Filter {
        private String filter;

        private LegacyFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public void appendFilter(StringBuilder sb) throws IOException {
            sb.append(this.filter);
        }

        @Override
        public void applyCmsId(String cmsId) {
            this.filter = FilterProcessor.processFilter(this.filter, cmsId);
        }
    }

    private class OrderBy {
        private NuageVspAttribute attribute;
        private OrderType type;

        public OrderBy(NuageVspAttribute attribute, OrderType type) {
            this.attribute = attribute;
            this.type = type;
        }

        public NuageVspAttribute getAttribute() {
            return this.attribute;
        }

        public OrderType getType() {
            return this.type;
        }

        public void appendOrderBy(StringBuilder appendable) throws IOException {
            NuageVspFilter.this.filterBuilderStrategy.appendField(appendable, this.attribute);
            appendable.append(" ").append(this.type.name());
        }
    }

    private static interface Filter {
        public void appendFilter(StringBuilder var1) throws IOException;

        default public void addFilter(Filter filter) {
            throw new UnsupportedOperationException();
        }

        default public boolean accept(GroupOp op) {
            return false;
        }

        public void applyCmsId(String var1);
    }

    public static enum OrderType {
        ASC,
        DESC;

    }

    private static enum GroupOp {
        OR,
        AND;

    }

    protected static enum BinaryOp {
        EQ,
        NE,
        LT,
        GT,
        LE,
        GE,
        LIKE,
        CONTAINS,
        STARTS_WITH,
        ENDS_WITH;

    }

    private static enum UnaryOp {
        NOT;

    }

    static class VspFilterBuilderStrategy
    implements FilterBuilderStrategy {
        private NuageVspApiVersion apiVersion;
        private static final EnumMap<BinaryOp, String> operatorMap = new EnumMap(BinaryOp.class);

        public VspFilterBuilderStrategy(NuageVspApiVersion apiVersion) {
            this.apiVersion = apiVersion;
        }

        @Override
        public void appendField(StringBuilder appendable, NuageVspAttribute attribute) throws IOException {
            appendable.append(attribute.getAttributeName(this.apiVersion));
        }

        @Override
        public void appendBinaryOperator(StringBuilder appendable, BinaryOp operator, Object value) throws IOException {
            appendable.append(operatorMap.get((Object)operator)).append(" ");
            if (value instanceof CharSequence) {
                appendable.append("'");
                appendable.append(value.toString());
                appendable.append("'");
            } else if (value != null) {
                appendable.append(value.toString());
            } else {
                appendable.append("null");
            }
        }

        static {
            operatorMap.put(BinaryOp.EQ, "==");
            operatorMap.put(BinaryOp.NE, "!=");
            operatorMap.put(BinaryOp.LT, "lt");
            operatorMap.put(BinaryOp.LE, "le");
            operatorMap.put(BinaryOp.GT, "gt");
            operatorMap.put(BinaryOp.GE, "ge");
            operatorMap.put(BinaryOp.LIKE, "LIKE");
            operatorMap.put(BinaryOp.CONTAINS, "CONTAINS");
            operatorMap.put(BinaryOp.STARTS_WITH, "BEGINSWITH");
            operatorMap.put(BinaryOp.ENDS_WITH, "ENDSWITH");
        }
    }

    static interface FilterBuilderStrategy {
        public void appendField(StringBuilder var1, NuageVspAttribute var2) throws IOException;

        public void appendBinaryOperator(StringBuilder var1, BinaryOp var2, Object var3) throws IOException;
    }
}

