/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import org.apache.commons.lang.ObjectUtils;

public class NuageVspObject
implements Serializable {
    private final EnumMap<NuageVspAttribute, Object> data;
    private final NuageVspEntity entity;
    private final NuageVspApiVersion apiVersion;
    private final Function<NuageVspAttribute, String> getAttributeValueFunction = new Function<NuageVspAttribute, String>(){

        public String apply(NuageVspAttribute attribute) {
            return (String)NuageVspObject.this.get(attribute);
        }
    };

    public NuageVspObject(NuageVspApiVersion apiVersion, NuageVspEntity entity) {
        this.data = new EnumMap(NuageVspAttribute.class);
        this.apiVersion = apiVersion;
        this.entity = entity;
    }

    public NuageVspObject copy() {
        NuageVspObject copy = new NuageVspObject(this.apiVersion, this.entity);
        copy.data.putAll(this.data);
        return copy;
    }

    public NuageVspObject(NuageVspApiVersion apiVersion, NuageVspEntity entity, String id) {
        this(apiVersion, entity);
        this.setId(id);
    }

    public <T> T get(NuageVspAttribute field) {
        assert (this.entity.hasAttribute(field));
        return (T)this.data.get((Object)field);
    }

    public NuageVspObject set(NuageVspAttribute field, Object value) {
        assert (this.entity.hasAttribute(field));
        this.data.put(field, value);
        return this;
    }

    public NuageVspObject unset(NuageVspAttribute field) {
        assert (this.entity.hasAttribute(field));
        this.data.remove((Object)field);
        return this;
    }

    public boolean hasAttribute(NuageVspAttribute field) {
        return this.data.containsKey((Object)field);
    }

    public NuageVspApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public NuageVspEntity getEntityType() {
        return this.entity;
    }

    public NuageVspObject setExternalId(String value) {
        return this.set(NuageVspAttribute.EXTERNAL_ID, value);
    }

    public void setId(String value) {
        this.set(NuageVspAttribute.ID, value);
    }

    public String getId() {
        return (String)this.get(NuageVspAttribute.ID);
    }

    public String getExternalId() {
        return (String)this.get(NuageVspAttribute.EXTERNAL_ID);
    }

    public String getName() {
        return (String)this.entity.getNameAttribute().transform(this.getAttributeValueFunction).orNull();
    }

    public String getDescription() {
        try {
            return (String)this.entity.getDescriptionAttribute().transform(this.getAttributeValueFunction).orNull();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public boolean entriesEqualTo(Object o) {
        if (o == null || !(o instanceof NuageVspObject)) {
            return false;
        }
        NuageVspObject other = (NuageVspObject)o;
        if (!this.entity.equals((Object)other.getEntityType())) {
            return false;
        }
        for (Map.Entry<NuageVspAttribute, Object> entry : other.data.entrySet()) {
            Object thatValue;
            Object thisValue = this.data.get((Object)entry.getKey());
            if (ObjectUtils.equals((Object)thisValue, (Object)(thatValue = entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public Set<Map.Entry<NuageVspAttribute, Object>> entrySet() {
        return this.data.entrySet();
    }

    public String toString() {
        return this.data.toString();
    }

    public String toFilterString() {
        StringBuilder appendable = new StringBuilder();
        Iterator<Map.Entry<NuageVspAttribute, Object>> entryIterator = this.data.entrySet().iterator();
        if (entryIterator.hasNext()) {
            this.appendFilterString(appendable, entryIterator.next());
            while (entryIterator.hasNext()) {
                appendable.append(" AND ");
                this.appendFilterString(appendable, entryIterator.next());
            }
        }
        return appendable.toString();
    }

    private void appendFilterString(StringBuilder appendable, Map.Entry<NuageVspAttribute, Object> entry) {
        String operator = entry.getKey() == NuageVspAttribute.EXTERNAL_ID ? " BEGINSWITH " : " == ";
        appendable.append(entry.getKey().getAttributeName(this.apiVersion));
        appendable.append(operator);
        Object value = entry.getValue();
        if (value instanceof CharSequence) {
            appendable.append('\"').append((CharSequence)value).append('\"');
        } else {
            appendable.append(value.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NuageVspObject)) {
            return false;
        }
        NuageVspObject that = (NuageVspObject)obj;
        if (this == that) {
            return true;
        }
        return Objects.equals((Object)this.entity, (Object)that.entity) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

